/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.tokenizer.RegExTokenizerFactory;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class RegExTokenizerFactoryTest {
    @Test
    public void testPositions() {
        RegExTokenizerFactory factory = new RegExTokenizerFactory("[a-z]+");
        String s = "  John ran/walked to the store. ";
        char[] cs = s.toCharArray();
        Tokenizer tokenizer = factory.tokenizer(cs, 7, 24);
        junit.framework.Assert.assertEquals((int)-1, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)-1, (int)tokenizer.lastTokenEndPosition());
        String token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"ran", (String)token);
        junit.framework.Assert.assertEquals((int)0, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)3, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextWhitespace();
        junit.framework.Assert.assertEquals((int)0, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)3, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"walked", (String)token);
        junit.framework.Assert.assertEquals((int)4, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)10, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextWhitespace();
        junit.framework.Assert.assertEquals((int)4, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)10, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        token = tokenizer.nextToken();
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((int)18, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)23, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextWhitespace();
        junit.framework.Assert.assertEquals((int)18, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)23, (int)tokenizer.lastTokenEndPosition());
        junit.framework.Assert.assertNull((Object)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)18, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)23, (int)tokenizer.lastTokenEndPosition());
    }

    @Test
    public void testOne() throws IOException, ClassNotFoundException {
        RegExTokenizerFactory factory = new RegExTokenizerFactory("[a-zA-Z]+|[0-9]+|\\S");
        char[] cs = "abc de 123. ".toCharArray();
        String[] whites = new String[]{"", " ", " ", "", " "};
        String[] toks = new String[]{"abc", "de", "123", "."};
        int[] nArray = new int[4];
        nArray[1] = 4;
        nArray[2] = 7;
        nArray[3] = 10;
        int[] starts = nArray;
        Tokenizer tokenizer = factory.tokenizer(cs, 0, cs.length);
        junit.framework.Assert.assertTrue((tokenizer != null ? 1 : 0) != 0);
        this.assertTokenize(new String(cs), whites, toks, starts, factory);
        TokenizerFactory factory2 = (TokenizerFactory)AbstractExternalizable.serializeDeserialize(factory);
        this.assertTokenize(new String(cs), whites, toks, starts, factory2);
    }

    protected void assertTokenize(String input, String[] whitespaces, String[] tokens, int[] starts, TokenizerFactory factory) {
        Assert.assertArrayEquals((Object[])tokens, (Object[])factory.tokenizer(input.toCharArray(), 0, input.length()).tokenize());
        Tokenizer tokenizer = factory.tokenizer(input.toCharArray(), 0, input.length());
        int i = 0;
        while (i < starts.length) {
            String whitespace = tokenizer.nextWhitespace();
            String token = tokenizer.nextToken();
            junit.framework.Assert.assertEquals((String)"Whitespace mismatch", (String)whitespaces[i], (String)whitespace);
            junit.framework.Assert.assertEquals((String)"Token mismatch", (String)tokens[i], (String)token);
            junit.framework.Assert.assertEquals((String)"Last token start position mismatch", (int)starts[i], (int)tokenizer.lastTokenStartPosition());
            ++i;
        }
        junit.framework.Assert.assertEquals((String)"Final whitespace mismatch", (String)whitespaces[whitespaces.length - 1], (String)tokenizer.nextWhitespace());
        junit.framework.Assert.assertNull((String)"Should return final null", (Object)tokenizer.nextToken());
    }
}

