/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.test.unit.Asserts;
import com.aliasi.test.unit.tokenizer.TokenizerTest;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.RegExFilteredTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import java.util.regex.Pattern;
import org.junit.Test;

public class RegExFilteredTokenizerFactoryTest {
    static final Pattern TEST_PATTERN = Pattern.compile("[A-Z][A-Z]+");

    @Test
    public void testFactory() {
        IndoEuropeanTokenizerFactory ieFactory = IndoEuropeanTokenizerFactory.INSTANCE;
        RegExFilteredTokenizerFactory factory = new RegExFilteredTokenizerFactory(ieFactory, TEST_PATTERN);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "", new String[0]);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "a", new String[0]);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "A", new String[0]);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "The starling is flying towards home smiling happily", new String[0]);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "a AA A BBB c DDD", "AA", "BBB", "DDD");
    }

    @Test
    public void testNotSerializable() {
        RegExFilteredTokenizerFactory unserializable = new RegExFilteredTokenizerFactory(TokenizerTest.UNSERIALIZABLE_FACTORY, TEST_PATTERN);
        Asserts.assertNotSerializable(unserializable);
    }
}

