/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.test.unit.Asserts;
import com.aliasi.test.unit.tokenizer.TokenizerTest;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.PorterStemmerTokenizerFactory;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import junit.framework.Assert;
import org.junit.Test;

public class PorterStemmerTokenizerFactoryTest {
    @Test
    public void testStartEnd() {
        PorterStemmerTokenizerFactory factory = new PorterStemmerTokenizerFactory(IndoEuropeanTokenizerFactory.INSTANCE);
        String s = "going running hastens  unfriendly things. Then";
        char[] cs = s.toCharArray();
        Tokenizer tokenizer = factory.tokenizer(cs, 5, cs.length - 5 - 4);
        Assert.assertEquals((int)-1, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)-1, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextToken();
        Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)8, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextWhitespace();
        Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)8, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextToken();
        Assert.assertEquals((int)9, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)16, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextWhitespace();
        Assert.assertEquals((int)9, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)16, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextToken();
        Assert.assertEquals((int)18, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)28, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextToken();
        Assert.assertEquals((int)29, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)35, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextToken();
        Assert.assertEquals((int)35, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)36, (int)tokenizer.lastTokenEndPosition());
    }

    @Test
    public void testFactory() {
        IndoEuropeanTokenizerFactory ieFactory = IndoEuropeanTokenizerFactory.INSTANCE;
        PorterStemmerTokenizerFactory factory = new PorterStemmerTokenizerFactory(ieFactory);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "", new String[0]);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "a", "a");
        TokenizerTest.assertFactory((TokenizerFactory)factory, "A", "A");
        TokenizerTest.assertFactory((TokenizerFactory)factory, "The starling is flying towards home smiling happily", PorterStemmerTokenizerFactory.stem("The"), PorterStemmerTokenizerFactory.stem("starling"), PorterStemmerTokenizerFactory.stem("is"), PorterStemmerTokenizerFactory.stem("flying"), PorterStemmerTokenizerFactory.stem("towards"), PorterStemmerTokenizerFactory.stem("home"), PorterStemmerTokenizerFactory.stem("smiling"), PorterStemmerTokenizerFactory.stem("happily"));
    }

    @Test
    public void testNotSerializable() {
        PorterStemmerTokenizerFactory unserializable = new PorterStemmerTokenizerFactory(TokenizerTest.UNSERIALIZABLE_FACTORY);
        Asserts.assertNotSerializable(unserializable);
    }
}

