/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.tokenizer.LineTokenizerFactory;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import org.junit.Test;

public class LineTokenizerFactoryTest {
    @Test
    public void testSingleton() throws IOException {
        LineTokenizerFactory fact = LineTokenizerFactory.INSTANCE;
        Object deserFact = AbstractExternalizable.serializeDeserialize(fact);
        Assert.assertTrue((fact == deserFact ? 1 : 0) != 0);
    }

    @Test
    public void testOne() {
        this.assertTokenizer("", new String[0], new String[]{""});
        this.assertTokenizer("abc", new String[]{"abc"}, new String[]{"", ""});
        this.assertTokenizer("abc\n", new String[]{"abc"}, new String[]{"", "\n"});
        this.assertTokenizer("  \n", new String[]{"  "}, new String[]{"", "\n"});
        this.assertTokenizer("abc\n def ", new String[]{"abc", " def "}, new String[]{"", "\n", ""});
        this.assertTokenizer("abc\r\ndef", new String[]{"abc", "def"}, new String[]{"", "\r\n", ""});
        this.assertTokenizer("abc\rdef", new String[]{"abc", "def"}, new String[]{"", "\r", ""});
        this.assertTokenizer("abc\u2029def", new String[]{"abc", "def"}, new String[]{"", "\u2029", ""});
    }

    void assertTokenizer(String input, String[] tokens, String[] whitespaces) {
        LineTokenizerFactory tf = LineTokenizerFactory.INSTANCE;
        Tokenizer tokenizer = tf.tokenizer(input.toCharArray(), 0, input.length());
        ArrayList tokenList = new ArrayList();
        ArrayList whiteList = new ArrayList();
        tokenizer.tokenize(tokenList, whiteList);
        Assert.assertEquals(Arrays.asList(tokens), tokenList);
        if (whitespaces != null) {
            Assert.assertEquals(Arrays.asList(whitespaces), whiteList);
        }
    }
}

