/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.symbol;

import com.aliasi.symbol.MapSymbolTable;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class MapSymbolTableTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConstructorDupDetection() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("foo", 1);
        map.put("bar", 2);
        map.put("baz", 3);
        map.put("bing", 2);
        new MapSymbolTable(map);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorNegDetection() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("foo", 1);
        map.put("bar", -1);
        map.put("baz", 3);
        new MapSymbolTable(map);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testExc1() {
        MapSymbolTable table = new MapSymbolTable();
        table.idToSymbol(1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testExc2() {
        MapSymbolTable table = new MapSymbolTable();
        table.idToSymbol(-1);
    }

    @Test
    public void testOne() {
        MapSymbolTable table = new MapSymbolTable();
        Assert.assertEquals((int)0, (int)table.numSymbols());
        Assert.assertEquals((int)-1, (int)table.symbolToID("abc"));
        Assert.assertEquals((int)0, (int)table.getOrAddSymbol("abc"));
        Assert.assertEquals((int)0, (int)table.getOrAddSymbol("abc"));
        Assert.assertEquals((int)0, (int)table.symbolToID("abc"));
        Assert.assertEquals((String)"abc", (String)table.idToSymbol(0));
        Assert.assertEquals((int)1, (int)table.getOrAddSymbol("xyz"));
        Assert.assertEquals((int)1, (int)table.getOrAddSymbol("xyz"));
        Assert.assertEquals((int)1, (int)table.symbolToID("xyz"));
        Assert.assertEquals((String)"xyz", (String)table.idToSymbol(1));
        Assert.assertEquals((int)2, (int)table.getOrAddSymbol("mno"));
        Assert.assertEquals((int)2, (int)table.getOrAddSymbol("mno"));
        Assert.assertEquals((int)2, (int)table.symbolToID("mno"));
        Assert.assertEquals((String)"mno", (String)table.idToSymbol(2));
        Assert.assertEquals((int)-1, (int)table.symbolToID("jk"));
        Assert.assertEquals((int)-1, (int)table.symbolToID("abcd"));
        Set<Integer> ids = table.idSet();
        Assert.assertEquals((int)3, (int)table.numSymbols());
        Assert.assertEquals((int)ids.size(), (int)table.numSymbols());
        Assert.assertEquals((int)3, (int)ids.size());
        Assert.assertTrue((boolean)ids.contains(0));
        Assert.assertTrue((boolean)ids.contains(1));
        Assert.assertTrue((boolean)ids.contains(2));
    }

    @Test
    public void testTwo() {
        MapSymbolTable table = new MapSymbolTable();
        Assert.assertEquals((int)0, (int)table.numSymbols());
        table.getOrAddSymbol("a");
        Assert.assertEquals((int)1, (int)table.numSymbols());
        Assert.assertEquals((String)"a", (String)table.idToSymbol(table.symbolToID("a")));
        Assert.assertEquals((int)table.symbolToID("a"), (int)table.getOrAddSymbol("a"));
        Assert.assertEquals((int)1, (int)table.numSymbols());
        table.getOrAddSymbol("b");
        Assert.assertEquals((int)2, (int)table.numSymbols());
        int bId = table.symbolToID("b");
        Assert.assertEquals((int)bId, (int)table.removeSymbol("b"));
        Assert.assertEquals((int)1, (int)table.numSymbols());
        table.getOrAddSymbol("c");
        table.clear();
        Assert.assertEquals((int)0, (int)table.numSymbols());
        Assert.assertEquals((int)-1, (int)table.symbolToID("a"));
        Assert.assertEquals((int)-1, (int)table.symbolToID("b"));
        Assert.assertEquals((int)-1, (int)table.symbolToID("c"));
    }

    @Test
    public void testThree() throws ClassNotFoundException, IOException {
        MapSymbolTable table = new MapSymbolTable();
        int aID = table.getOrAddSymbol("a");
        Assert.assertEquals((int)aID, (int)table.getOrAddSymbol("a"));
        Assert.assertEquals((int)aID, (int)table.symbolToID("a"));
        Assert.assertEquals((String)"a", (String)table.idToSymbol(table.symbolToID("a")));
        int bID = table.getOrAddSymbol("b");
        int cdID = table.getOrAddSymbol("cd");
        MapSymbolTable table2 = (MapSymbolTable)AbstractExternalizable.serializeDeserialize(table);
        Assert.assertEquals((int)3, (int)table2.numSymbols());
        Assert.assertEquals((int)bID, (int)table2.symbolToID("b"));
        Assert.assertEquals((int)cdID, (int)table2.symbolToID("cd"));
    }

    @Test
    public void testFour() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 45);
        map.put("b", 0);
        map.put("c", 1);
        MapSymbolTable table = new MapSymbolTable(map);
        Assert.assertEquals((int)table.numSymbols(), (int)3);
        Assert.assertEquals((int)45, (int)table.symbolToID("a"));
        Assert.assertEquals((int)0, (int)table.symbolToID("b"));
        Assert.assertEquals((int)1, (int)table.symbolToID("c"));
        Assert.assertEquals((int)-1, (int)table.symbolToID("d"));
        Assert.assertEquals((int)46, (int)table.getOrAddSymbol("d"));
    }
}

