/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.suffixarray;

import com.aliasi.suffixarray.TokenSuffixArray;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.Tokenization;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class TokenSuffixArrayTest {
    @Test
    public void testAbracadabra() {
        String cs = "aXYZ bUV ruzw aXYZ ctru aXYZ dF900 aXYZ bUV ruzw aXYZ ";
        TokenSuffixArray tsa = new TokenSuffixArray(new Tokenization(cs, IndoEuropeanTokenizerFactory.INSTANCE), Integer.MAX_VALUE);
        junit.framework.Assert.assertNotNull((Object)tsa);
        junit.framework.Assert.assertEquals((String)cs, (String)tsa.tokenization().text());
        int[] nArray = new int[11];
        nArray[0] = 10;
        nArray[1] = 7;
        nArray[3] = 3;
        nArray[4] = 5;
        nArray[5] = 8;
        nArray[6] = 1;
        nArray[7] = 4;
        nArray[8] = 6;
        nArray[9] = 9;
        nArray[10] = 2;
        int[] expected_sa = nArray;
        junit.framework.Assert.assertEquals((int)expected_sa.length, (int)tsa.suffixArrayLength());
        int i = 0;
        while (i < expected_sa.length) {
            junit.framework.Assert.assertEquals((int)expected_sa[i], (int)tsa.suffixArray(i));
            ++i;
        }
        List<int[]> prefixMatches = tsa.prefixMatches(3);
        Assert.assertArrayEquals((int[])new int[]{1, 3}, (int[])prefixMatches.get(0));
        Assert.assertArrayEquals((int[])new int[]{5, 7}, (int[])prefixMatches.get(1));
        junit.framework.Assert.assertEquals((int)2, (int)prefixMatches.size());
        junit.framework.Assert.assertEquals((String)"aXYZ bUV", (String)tsa.substring(1, 2));
        junit.framework.Assert.assertEquals((String)"aXYZ bUV", (String)tsa.substring(2, 2));
        junit.framework.Assert.assertEquals((String)"bUV ruzw aXYZ", (String)tsa.substring(5, 3));
        junit.framework.Assert.assertEquals((String)"bUV ruzw aXYZ", (String)tsa.substring(6, 3));
    }

    @Test
    public void testEmpty() {
        String cs = "";
        TokenSuffixArray tsa = new TokenSuffixArray(new Tokenization(cs, IndoEuropeanTokenizerFactory.INSTANCE));
        junit.framework.Assert.assertEquals((String)cs, (String)tsa.tokenization().text());
        junit.framework.Assert.assertEquals((int)0, (int)tsa.suffixArrayLength());
        junit.framework.Assert.assertEquals((int)0, (int)tsa.prefixMatches(3).size());
    }

    @Test
    public void testLengthBound() {
        String cs = "aa bb aa bb aa bb cc cc cc";
        Tokenization tokenization = new Tokenization(cs, IndoEuropeanTokenizerFactory.INSTANCE);
        TokenSuffixArray tsa = new TokenSuffixArray(tokenization, 1);
        List<int[]> prefixMatches = tsa.prefixMatches(1);
        junit.framework.Assert.assertEquals((int)3, (int)prefixMatches.size());
        for (int[] match : prefixMatches) {
            junit.framework.Assert.assertEquals((int)3, (int)(match[1] - match[0]));
            int j = match[0] + 1;
            while (j < match[1]) {
                junit.framework.Assert.assertEquals((String)tokenization.token(tsa.suffixArray(j - 1)), (String)tokenization.token(tsa.suffixArray(j)));
                ++j;
            }
        }
    }

    @Test
    public void testBoundaryToken() {
        String cs = "aa bb X cc aa bb cc X";
        Tokenization tokenization = new Tokenization(cs, IndoEuropeanTokenizerFactory.INSTANCE);
        TokenSuffixArray tsa = new TokenSuffixArray(tokenization, Integer.MAX_VALUE, "X");
        List<int[]> prefixMatches = tsa.prefixMatches(2);
        junit.framework.Assert.assertEquals((int)1, (int)prefixMatches.size());
        int[] match = prefixMatches.get(0);
        junit.framework.Assert.assertEquals((String)"aa bb", (String)tsa.substring(match[0], 2));
        junit.framework.Assert.assertEquals((String)"aa bb", (String)tsa.substring(match[0] + 1, 2));
    }
}

