/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.ZipfDistribution;
import com.aliasi.util.Math;
import junit.framework.Assert;
import org.junit.Test;

public class ZipfDistributionTest {
    @Test
    public void testZero() {
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExs() {
        new ZipfDistribution(-1);
    }

    @Test
    public void testDistro() {
        ZipfDistribution dist = new ZipfDistribution(3);
        Assert.assertEquals((int)3, (int)dist.numOutcomes());
        double sum = 1.8333333333333333;
        double p1 = 1.0 / sum;
        double p2 = 0.5 / sum;
        double p3 = 0.3333333333333333 / sum;
        Assert.assertEquals((double)p1, (double)dist.probability(1L), (double)5.0E-4);
        Assert.assertEquals((double)p2, (double)dist.probability(2L), (double)5.0E-4);
        Assert.assertEquals((double)p3, (double)dist.probability(3L), (double)5.0E-4);
        Assert.assertEquals((double)0.0, (double)dist.probability(0L), (double)5.0E-4);
        Assert.assertEquals((double)0.0, (double)dist.probability(-1L), (double)5.0E-4);
        Assert.assertEquals((double)0.0, (double)dist.probability(20L), (double)5.0E-4);
        double[] probs = ZipfDistribution.zipfDistribution(3);
        Assert.assertEquals((double)p1, (double)probs[0], (double)5.0E-4);
        Assert.assertEquals((double)p2, (double)probs[1], (double)5.0E-4);
        Assert.assertEquals((double)p3, (double)probs[2], (double)5.0E-4);
        Assert.assertEquals((double)(-(p1 * Math.log2(p1) + p2 * Math.log2(p2) + p3 * Math.log2(p3))), (double)dist.entropy(), (double)5.0E-4);
    }

    @Test
    public void testDistro2() {
        ZipfDistribution distro = new ZipfDistribution(100);
        double sum = 0.0;
        int i = 0;
        while (i < 100) {
            sum += distro.probability(i);
            ++i;
        }
        Assert.assertEquals((double)1.0, (double)sum, (double)0.005);
        Assert.assertEquals((double)2.0, (double)(distro.probability(1L) / distro.probability(2L)), (double)0.001);
    }
}

