/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.Statistics;
import com.aliasi.test.unit.Asserts;
import com.aliasi.util.Math;
import java.util.HashSet;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class StatisticsTest {
    @Test
    public void testDirDivergence() {
        Random random = new Random();
        int k = 0;
        while (k < 100) {
            double[] xs = new double[random.nextInt(100) + 2];
            double[] ys = new double[xs.length];
            int i = 0;
            while (i < xs.length) {
                xs[i] = random.nextDouble() * 10.0;
                ++i;
            }
            i = 0;
            while (i < xs.length) {
                ys[i] = random.nextDouble() * 10.0;
                ++i;
            }
            Assert.assertEquals((double)0.0, (double)Statistics.klDivergenceDirichlet(xs, xs), (double)1.0E-4);
            Assert.assertTrue((0.0 <= Statistics.klDivergenceDirichlet(xs, ys) ? 1 : 0) != 0);
            ++k;
        }
    }

    @Test
    public void testDivergenceExceptions() {
        double[] p = new double[]{0.5, 0.2, 0.3};
        double[] q = new double[]{0.2, 0.8};
        double[] r = new double[]{0.1, -0.2, 0.7};
        double[] s = new double[]{0.1, 1.2, 0.7};
        double[] t = new double[]{0.1, Double.POSITIVE_INFINITY, 0.7};
        double[] u = new double[]{Double.NEGATIVE_INFINITY, 0.7, 0.3};
        double[] v = new double[]{0.1, 0.2, Double.NaN};
        this.assertFailDivergence(p, q);
        this.assertFailDivergence(p, r);
        this.assertFailDivergence(p, s);
        this.assertFailDivergence(p, t);
        this.assertFailDivergence(p, u);
        this.assertFailDivergence(p, v);
    }

    void assertFailDivergence(double[] p, double[] q) {
        try {
            Statistics.klDivergence(p, q);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            Statistics.klDivergence(q, p);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            Statistics.symmetrizedKlDivergence(p, q);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            Statistics.symmetrizedKlDivergence(q, p);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            Statistics.jsDivergence(p, q);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            Statistics.jsDivergence(q, p);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }

    @Test
    public void testEqualDivergences() {
        double[] p = new double[]{0.1, 0.4, 0.5};
        double[] q = new double[]{0.1, 0.4, 0.5};
        Assert.assertEquals((double)0.0, (double)Statistics.klDivergence(p, q), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)Statistics.symmetrizedKlDivergence(p, q), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)Statistics.jsDivergence(p, q), (double)1.0E-4);
        double[] r = new double[]{};
        Assert.assertEquals((double)0.0, (double)Statistics.klDivergence(r, r), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)Statistics.symmetrizedKlDivergence(r, r), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)Statistics.jsDivergence(r, r), (double)1.0E-4);
        double[] s = new double[]{1.0};
        Assert.assertEquals((double)0.0, (double)Statistics.klDivergence(s, s), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)Statistics.symmetrizedKlDivergence(s, s), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)Statistics.jsDivergence(s, s), (double)1.0E-4);
    }

    @Test
    public void testDivergences() {
        double[] p = new double[]{0.4, 0.6};
        double[] q = new double[]{0.6, 0.4};
        double expectedKl = 0.4 * Math.log2(0.6666666666666667) + 0.6 * Math.log2(1.4999999999999998);
        Assert.assertEquals((double)expectedKl, (double)Statistics.klDivergence(p, q), (double)1.0E-4);
        double expectedSkl = expectedKl;
        Assert.assertEquals((double)expectedSkl, (double)Statistics.symmetrizedKlDivergence(p, q), (double)1.0E-4);
        Assert.assertEquals((double)expectedSkl, (double)Statistics.symmetrizedKlDivergence(q, p), (double)1.0E-4);
        double expectedJs = 0.4 * Math.log2(0.8) + 0.6 * Math.log2(1.2);
        Assert.assertEquals((double)expectedJs, (double)Statistics.jsDivergence(p, q), (double)1.0E-4);
        Assert.assertEquals((double)expectedJs, (double)Statistics.jsDivergence(q, p), (double)1.0E-4);
    }

    @Test
    public void testPermutation() {
        int[] xs = Statistics.permutation(0);
        Assert.assertEquals((int)0, (int)xs.length);
        xs = Statistics.permutation(1);
        Assert.assertEquals((int)1, (int)xs.length);
        Assert.assertEquals((int)0, (int)xs[0]);
        xs = Statistics.permutation(2);
        Assert.assertEquals((int)2, (int)xs.length);
        Assert.assertTrue((xs[0] == 0 && xs[1] == 1 || xs[0] == 1 && xs[1] == 0 ? 1 : 0) != 0);
        xs = Statistics.permutation(100);
        HashSet<Integer> xSet = new HashSet<Integer>(200);
        int i = 0;
        while (i < xs.length) {
            Assert.assertTrue((xs[i] >= 0 && xs[i] < 100 ? 1 : 0) != 0);
            xSet.add(xs[i]);
            ++i;
        }
        Assert.assertEquals((int)100, (int)xSet.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegressionExceptions1() {
        double[] xs = new double[]{1.0};
        double[] ys = new double[]{2.0};
        Statistics.linearRegression(xs, ys);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegressionExceptions2() {
        double[] xs = new double[]{1.0};
        double[] ys = new double[]{2.0};
        Statistics.logisticRegression(xs, ys, 2.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegressionExceptions3() {
        double[] xs2 = new double[]{1.0, 2.0};
        double[] ys3 = new double[]{1.0, 2.0, 3.0};
        Statistics.linearRegression(xs2, ys3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegressionExceptions4() {
        double[] xs2 = new double[]{1.0, 2.0};
        double[] ys3 = new double[]{1.0, 2.0, 3.0};
        Statistics.logisticRegression(xs2, ys3, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegressionExceptions5() {
        double[] xs4 = new double[]{1.0, 1.0, 1.0, 1.0};
        double[] ys4 = new double[]{2.0, 2.0, 2.0, 2.0};
        Statistics.linearRegression(xs4, ys4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegressionExceptions6() {
        double[] xs4 = new double[]{1.0, 1.0, 1.0, 1.0};
        double[] ys4 = new double[]{2.0, 2.0, 2.0, 2.0};
        Statistics.logisticRegression(xs4, ys4, 2.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegressionExceptions7() {
        double[] xs3 = new double[]{5.0, 9.0, 7.0};
        double[] ys3 = new double[]{1.0, 2.0, 3.0};
        Statistics.logisticRegression(xs3, ys3, -1.0);
    }

    @Test
    public void testLogisticRegression() {
        double[] xs = new double[]{480.0, 690.0, 900.0, 1100.0, 1320.0, 1530.0};
        double[] ys = new double[]{0.3, 4.6, 15.6, 33.4, 44.4, 45.7};
        double[] betas = Statistics.logisticRegression(xs, ys, 48.0);
        Assert.assertEquals((double)7.91, (double)betas[0], (double)0.1);
        Assert.assertEquals((double)-0.0076, (double)betas[1], (double)1.0E-4);
    }

    @Test
    public void testRegression() {
        double[] xs = new double[]{1.0, 2.0};
        double[] ys = new double[]{3.0, 4.0};
        double[] betas = Statistics.linearRegression(xs, ys);
        Assert.assertEquals((double)betas[0], (double)2.0, (double)0.001);
        Assert.assertEquals((double)betas[1], (double)1.0, (double)0.001);
    }

    @Test
    public void testRegression2() {
        double[] xs = new double[]{2.745, 2.7, 2.69, 2.68, 2.675, 2.67, 2.665, 2.66, 2.655, 2.655, 2.65, 2.65, 2.645, 2.635, 2.63, 2.625, 2.625, 2.62, 2.615, 2.615, 2.615, 2.61, 2.59, 2.59, 2.565};
        double[] ys = new double[]{2.08, 2.045, 2.05, 2.005, 2.035, 2.035, 2.02, 2.005, 2.01, 2.0, 2.0, 2.005, 2.015, 1.99, 1.99, 1.995, 1.985, 1.97, 1.985, 1.99, 1.995, 1.99, 1.975, 1.995, 1.955};
        double[] betas = Statistics.linearRegression(xs, ys);
        Assert.assertEquals((double)betas[0], (double)0.308, (double)0.01);
        Assert.assertEquals((double)betas[1], (double)0.642, (double)0.01);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCorrelationExc() {
        Statistics.correlation(new double[]{1.0, 2.0}, new double[]{3.0, 4.0, 5.0});
    }

    @Test
    public void testCorrelation() {
        double[] xs = new double[]{61.0, 61.0, 62.5, 63.0, 66.0, 70.0, 73.0, 75.5};
        double[] ys = new double[]{61.0, 63.0, 65.0, 63.0, 67.0, 72.0, 74.0, 75.5};
        Assert.assertEquals((double)0.983798, (double)Statistics.correlation(xs, ys), (double)1.0E-4);
        double[] zs1 = new double[]{1.0, 2.0, 3.0};
        double[] zs2 = new double[]{2.0, 4.0, 6.0};
        double[] zs3 = new double[]{-1.0, -2.0, -3.0};
        Assert.assertEquals((double)1.0, (double)Statistics.correlation(zs1, zs2), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)Statistics.correlation(zs1, zs3), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)Statistics.correlation(zs2, zs3), (double)1.0E-4);
    }

    @Test
    public void testChiSquareMatrix() {
        double[][] matrix = new double[][]{{70.0, 65.0}, {39.0, 28.0}, {14.0, 3.0}, {13.0, 2.0}};
        Assert.assertEquals((double)11.3, (double)Statistics.chiSquaredIndependence(matrix), (double)0.1);
        matrix = new double[][]{{24.0, 8.0, 13.0}, {8.0, 13.0, 11.0}, {10.0, 9.0, 64.0}};
        Assert.assertEquals((double)45.37, (double)Statistics.chiSquaredIndependence(matrix), (double)0.1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChiSqExc1() {
        double[][] matrix = new double[][]{{1.0, 2.0}, {3.0, 5.0, 6.0}};
        Statistics.chiSquaredIndependence(matrix);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChiSqExc2() {
        double[][] matrix = new double[][]{{1.0, -2.0, 3.0}, {4.0, 5.0, 6.0}};
        Statistics.chiSquaredIndependence(matrix);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChiSqExc3() {
        double[][] matrix = new double[][]{{1.0, 2.0, 3.0}, {4.0, Double.NaN, 6.0}};
        Statistics.chiSquaredIndependence(matrix);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChiSqExc4() {
        double[][] matrix = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, Double.POSITIVE_INFINITY}};
        Statistics.chiSquaredIndependence(matrix);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNormalizeExc1() {
        Statistics.normalize(new double[]{-1.0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNormalizeExc2() {
        Statistics.normalize(new double[]{0.0, 2.0, -1.0, 5.0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNormalizeExc3() {
        Statistics.normalize(new double[]{0.0, 2.0, Double.NaN, 5.0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNormalizeExc4() {
        Statistics.normalize(new double[]{0.0, 2.0, Double.POSITIVE_INFINITY, 5.0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNormalizeExc5() {
        Statistics.normalize(new double[]{0.0, 0.0, 0.0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNormalizeExc6() {
        Statistics.normalize(new double[0]);
    }

    @Test
    public void testNormalizeOK() {
        Assert.assertEquals((double)1.0, (double)Math.sum(Statistics.normalize(new double[]{0.0, 1.0, 2.0, 3.0})), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)Statistics.normalize(new double[]{17.0})[0], (double)1.0E-4);
    }

    @Test
    public void testChiSquare() {
        double both = 3.0;
        double oneOnly = 1.0;
        double twoOnly = 2.0;
        double neither = 4.0;
        double pOne = 0.4;
        double pTwo = 0.5;
        double eBoth = 10.0 * pOne * pTwo;
        double eOne = 10.0 * pOne * (1.0 - pTwo);
        double eTwo = 10.0 * (1.0 - pOne) * pTwo;
        double eNeither = 10.0 * (1.0 - pOne) * (1.0 - pTwo);
        double diffBoth = both - eBoth;
        double diffOne = oneOnly - eOne;
        double diffTwo = twoOnly - eTwo;
        double diffNeither = neither - eNeither;
        double eChiSquare = diffBoth * diffBoth / eBoth + diffOne * diffOne / eOne + diffTwo * diffTwo / eTwo + diffNeither * diffNeither / eNeither;
        Assert.assertEquals((double)eChiSquare, (double)Statistics.chiSquaredIndependence(both, oneOnly, twoOnly, neither), (double)5.0E-4);
        Assert.assertEquals((double)1.66666, (double)Statistics.chiSquaredIndependence(both, oneOnly, twoOnly, neither), (double)5.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChiSquareExcs1() {
        Statistics.chiSquaredIndependence(-1.0, 2.0, 3.0, 4.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChiSquareExcs2() {
        Statistics.chiSquaredIndependence(1.0, -2.0, 3.0, 4.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChiSquareExcs3() {
        Statistics.chiSquaredIndependence(1.0, 2.0, -3.0, 4.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChiSquareExcs4() {
        Statistics.chiSquaredIndependence(1.0, 2.0, 3.0, -4.0);
    }

    @Test
    public void testMeanVarDev() {
        double[] xs = new double[]{};
        Assert.assertTrue((boolean)Double.isNaN(Statistics.mean(xs)));
        Assert.assertTrue((boolean)Double.isNaN(Statistics.variance(xs)));
        Assert.assertTrue((boolean)Double.isNaN(Statistics.standardDeviation(xs)));
        xs = new double[]{1.0};
        Assert.assertEquals((double)1.0, (double)Statistics.mean(xs), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)Statistics.variance(xs), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)Statistics.standardDeviation(xs), (double)1.0E-4);
        xs = new double[]{1.0, 3.0};
        Assert.assertEquals((double)2.0, (double)Statistics.mean(xs), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)Statistics.variance(xs), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)Statistics.standardDeviation(xs), (double)1.0E-4);
        xs = new double[]{1.0, 3.0, 1.0, 3.0};
        Assert.assertEquals((double)2.0, (double)Statistics.mean(xs), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)Statistics.variance(xs), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)Statistics.standardDeviation(xs), (double)1.0E-4);
    }

    @Test
    public void testSampling() {
        Random baseRandom = new Random();
        int k = 0;
        while (k < 100) {
            int numTopics = baseRandom.nextInt(300) + 1;
            double[] probRatios = new double[numTopics];
            int i = 0;
            while (i < numTopics) {
                double d = probRatios[i] = i == 0 ? 0.0 : probRatios[i - 1];
                if (baseRandom.nextDouble() > 0.1) {
                    int n = i;
                    probRatios[n] = probRatios[n] + baseRandom.nextDouble() * 100.0;
                }
                ++i;
            }
            int j = 0;
            while (j < 100) {
                int sample;
                long seed = baseRandom.nextLong();
                double x = new Random(seed).nextDouble() * probRatios[numTopics - 1];
                Assert.assertTrue((x <= probRatios[sample = Statistics.sample(probRatios, new Random(seed))] ? 1 : 0) != 0);
                Assert.assertTrue((sample == 0 || x > probRatios[sample - 1] ? 1 : 0) != 0);
                ++j;
            }
            ++k;
        }
    }

    @Test
    public void testDirichlet() {
        this.assertDirichlet(2.0, new double[]{0.5, 0.5}, 1.5);
        this.assertDirichlet(new double[]{2.0, 2.0}, new double[]{0.5, 0.5}, 1.5);
        double log2Expected = Math.log2Gamma(4.0) - 2.0 * Math.log2Gamma(2.0) + Math.log2(0.25) + Math.log2(0.75);
        this.assertDirichlet(2.0, new double[]{0.25, 0.75}, java.lang.Math.pow(2.0, log2Expected));
        double log2Expected2 = Math.log2Gamma(12.0) - Math.log2Gamma(3.0) - Math.log2Gamma(4.0) - Math.log2Gamma(5.0) + Math.log2(java.lang.Math.pow(0.2, 2.0)) + Math.log2(java.lang.Math.pow(0.3, 3.0)) + Math.log2(java.lang.Math.pow(0.5, 4.0));
        this.assertDirichlet(new double[]{3.0, 4.0, 5.0}, new double[]{0.2, 0.3, 0.5}, java.lang.Math.pow(2.0, log2Expected2));
    }

    void assertDirichlet(double alpha, double[] xs, double expectedP) {
        double expectedLog2P = Math.log2(expectedP);
        Assert.assertEquals((double)expectedLog2P, (double)Statistics.dirichletLog2Prob(alpha, xs), (double)1.0E-4);
    }

    void assertDirichlet(double[] alphas, double[] xs, double expectedP) {
        double expectedLog2P = Math.log2(expectedP);
        Assert.assertEquals((double)expectedLog2P, (double)Statistics.dirichletLog2Prob(alphas, xs), (double)1.0E-4);
    }

    @Test
    public void testDirichletExceptions() {
        this.assertDirichletFail(-1.0, new double[]{0.5, 0.5});
        this.assertDirichletFail(0.0, new double[]{0.5, 0.5});
        this.assertDirichletFail(Double.NaN, new double[]{0.5, 0.5});
        this.assertDirichletFail(Double.POSITIVE_INFINITY, new double[]{0.5, 0.5});
        this.assertDirichletFail(new double[]{0.4, -1.0}, new double[]{0.25, 0.75});
        this.assertDirichletFail(new double[]{0.4, 0.0}, new double[]{0.25, 0.75});
        this.assertDirichletFail(new double[]{Double.NaN, 0.4}, new double[]{0.25, 0.75});
        this.assertDirichletFail(new double[]{0.4, 0.4, Double.POSITIVE_INFINITY}, new double[]{0.25, 0.5, 0.5});
        this.assertDirichletFail(1.0, new double[]{-1.0, 0.5});
        this.assertDirichletFail(new double[]{1.0, 1.0}, new double[]{-1.0, 0.5});
        this.assertDirichletFail(1.0, new double[]{0.25, 2.0});
        this.assertDirichletFail(new double[]{1.0, 1.0}, new double[]{0.5, 2.0});
        this.assertDirichletFail(1.0, new double[]{0.25, Double.NEGATIVE_INFINITY});
        this.assertDirichletFail(new double[]{1.0, 1.0}, new double[]{0.5, Double.POSITIVE_INFINITY});
        this.assertDirichletFail(new double[]{1.0, 1.0}, new double[]{0.5, Double.NaN});
        this.assertDirichletFail(new double[]{1.0, 2.0, 3.0}, new double[]{0.5, 0.5});
    }

    void assertDirichletFail(double alpha, double[] xs) {
        try {
            Statistics.dirichletLog2Prob(-1.0, new double[]{0.5, 0.5});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }

    void assertDirichletFail(double[] alphas, double[] xs) {
        try {
            Statistics.dirichletLog2Prob(alphas, xs);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }
}

