/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.PoissonDistribution;
import junit.framework.Assert;
import org.junit.Test;

public class PoissonDistributionTest {
    @Test
    public void testOne() {
        PoissonTest dist = new PoissonTest(2.0);
        PoissonDistributionTest.assertPoissonTwo(dist);
    }

    @Test
    public void testExceptions() {
        PoissonTest dist = new PoissonTest(2.0);
        Assert.assertTrue((Double.NEGATIVE_INFINITY == dist.log2Probability(-1L) ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)dist.probability(-1L), (double)0.005);
        dist = new PoissonTest(-1.0);
        try {
            dist.log2Probability(5L);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    static void assertSumOne(PoissonDistribution dist) {
        double sum = 0.0;
        int i = 0;
        while (i < 100) {
            double logProbI = dist.log2Probability(i);
            double probI = Math.pow(2.0, logProbI);
            sum += probI;
            ++i;
        }
        Assert.assertEquals((double)1.0, (double)sum, (double)0.005);
    }

    static void assertPoissonTwo(PoissonDistribution dist) {
        PoissonDistributionTest.assertSumOne(dist);
        Assert.assertEquals((long)0L, (long)dist.minOutcome());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)dist.maxOutcome());
        Assert.assertEquals((double)2.0, (double)dist.mean(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)dist.variance(), (double)1.0E-4);
    }

    static class PoissonTest
    extends PoissonDistribution {
        private final double mLambda;

        public PoissonTest(double lambda) {
            this.mLambda = lambda;
        }

        @Override
        public double mean() {
            return this.mLambda;
        }
    }
}

