/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.MultivariateConstant;
import com.aliasi.util.Math;
import java.util.Arrays;
import junit.framework.Assert;
import org.junit.Test;

public class MultivariateConstantTest {
    @Test
    public void testOne() {
        long[] counts = new long[10];
        Arrays.fill(counts, 5L);
        String[] labels = new String[10];
        int i = 0;
        while (i < labels.length) {
            labels[i] = Long.toString(i);
            ++i;
        }
        double[] ratios = new double[10];
        Arrays.fill(ratios, 0.72);
        this.assertDistro(new MultivariateConstant(10));
        this.assertDistro(new MultivariateConstant(counts));
        this.assertDistro(new MultivariateConstant(counts, labels));
        this.assertDistro(new MultivariateConstant(labels));
        this.assertDistro(new MultivariateConstant(ratios));
        this.assertDistro(new MultivariateConstant(ratios, labels));
    }

    @Test
    public void testExs() {
        try {
            new MultivariateConstant(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new MultivariateConstant(new long[]{3L, -1L});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new MultivariateConstant(new long[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new MultivariateConstant(new long[]{-1L, 2L}, new String[]{"foo", "bar"});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new MultivariateConstant(new long[]{-1L, 2L}, new String[]{"foo"});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new MultivariateConstant(new double[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new MultivariateConstant(new double[]{-1.0, 2.0}, new String[]{"foo", "bar"});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new MultivariateConstant(new double[]{-1.0, 2.0}, new String[]{"foo"});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new MultivariateConstant(new String[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new MultivariateConstant(new String[]{"foo", "bar", "baz", "bar"});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new MultivariateConstant(new long[]{1L, 2L, 3L, 4L}, new String[]{"foo", "bar", "baz", "bar"});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new MultivariateConstant(new double[]{1.0, 2.0, 3.0, 4.0}, new String[]{"foo", "bar", "baz", "bar"});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testLabelsExplicit() {
        MultivariateConstant mvc = new MultivariateConstant(new String[]{"foo", "bar"});
        Assert.assertEquals((String)"foo", (String)mvc.label(0L));
        Assert.assertEquals((String)"bar", (String)mvc.label(1L));
        try {
            mvc.label(2L);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertEquals((long)0L, (long)mvc.outcome("foo"));
        Assert.assertEquals((long)1L, (long)mvc.outcome("bar"));
        try {
            mvc.outcome("baz");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testLabelsImplicit() {
        MultivariateConstant mvc = new MultivariateConstant(4);
        Assert.assertEquals((String)"1", (String)mvc.label(1L));
        Assert.assertEquals((String)"3", (String)mvc.label(3L));
        try {
            mvc.label(4L);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertEquals((long)0L, (long)mvc.outcome("0"));
        Assert.assertEquals((long)2L, (long)mvc.outcome("2"));
        Assert.assertEquals((long)3L, (long)mvc.outcome("3"));
        Assert.assertEquals((long)-1L, (long)mvc.outcome("foo"));
        Assert.assertEquals((long)-1L, (long)mvc.outcome("4"));
    }

    public void assertDistro(MultivariateConstant distro) {
        Assert.assertEquals((long)0L, (long)distro.minOutcome());
        Assert.assertEquals((long)9L, (long)distro.maxOutcome());
        Assert.assertEquals((int)10, (int)distro.numDimensions());
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbabilityLess(4L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbabilityLess(-1L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityLess(9L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityLess(20L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbabilityGreater(5L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbabilityGreater(10L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityGreater(0L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityGreater(-20L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(1L, 5L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(-3L, 4L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(-3L, 4L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbability(-3L, -4L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbability(-3L, 15L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbability(0L, 9L), (double)0.001);
        Assert.assertEquals((double)0.1, (double)distro.probability(0L), (double)1.0E-4);
        Assert.assertEquals((double)0.1, (double)distro.probability(5L), (double)1.0E-4);
        Assert.assertEquals((double)0.1, (double)distro.probability(9L), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)distro.probability(17L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(0L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(5L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(9L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.0), (double)distro.log2Probability(17L), (double)1.0E-4);
        double mean = 4.5;
        double variance = 0.0;
        int i = 0;
        while (i < 10) {
            double diff = mean - (double)i;
            variance += diff * diff;
            ++i;
        }
        Assert.assertEquals((double)mean, (double)distro.mean(), (double)1.0E-4);
        Assert.assertEquals((double)(variance /= 10.0), (double)distro.variance(), (double)1.0E-4);
        double entropy = 0.0;
        int i2 = 0;
        while (i2 <= 9) {
            entropy += -distro.probability(i2) * distro.log2Probability(i2);
            ++i2;
        }
        Assert.assertEquals((double)entropy, (double)distro.entropy(), (double)1.0E-4);
    }
}

