/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.spell;

import com.aliasi.spell.WeightedEditDistance;
import junit.framework.Assert;
import org.junit.Test;

public class WeightedEditDistanceTest {
    private static WeightedEditDistance TRANSPOSING_EDIT = new Transposing();
    private static WeightedEditDistance NON_TRANSPOSING_EDIT = new NonTransposing();

    @Test
    public void testOne() {
        WeightedEditDistanceTest.assertDistance(0.0, "", "", true);
        WeightedEditDistanceTest.assertDistance(0.0, "", "", false);
        WeightedEditDistanceTest.assertDistance(1.0, "a", "", true);
        WeightedEditDistanceTest.assertDistance(1.0, "", "a", true);
        WeightedEditDistanceTest.assertDistance(1.0, "a", "", false);
        WeightedEditDistanceTest.assertDistance(1.0, "", "a", false);
        WeightedEditDistanceTest.assertDistance(1.0, "a", "ab", true);
        WeightedEditDistanceTest.assertDistance(1.0, "ab", "a", true);
        WeightedEditDistanceTest.assertDistance(1.0, "a", "ab", false);
        WeightedEditDistanceTest.assertDistance(1.0, "ab", "a", false);
        WeightedEditDistanceTest.assertDistance(1.0, "ab", "ba", true);
        WeightedEditDistanceTest.assertDistance(2.0, "ab", "ba", false);
        WeightedEditDistanceTest.assertDistance(1.0, "abc", "bac", true);
        WeightedEditDistanceTest.assertDistance(1.0, "abc", "acb", true);
        WeightedEditDistanceTest.assertDistance(2.0, "abc", "bac", false);
        WeightedEditDistanceTest.assertDistance(2.0, "abc", "acb", false);
        WeightedEditDistanceTest.assertDistance(1.0, "abcd", "bacd", true);
        WeightedEditDistanceTest.assertDistance(1.0, "abcd", "acbd", true);
        WeightedEditDistanceTest.assertDistance(1.0, "abcd", "abdc", true);
        WeightedEditDistanceTest.assertDistance(2.0, "dabc", "dbac", false);
        WeightedEditDistanceTest.assertDistance(2.0, "pwnag", "ownage", true);
        WeightedEditDistanceTest.assertDistance(2.0, "pwnag", "ownage", false);
        WeightedEditDistanceTest.assertDistance(2.0, "abxy", "bayx", true);
        WeightedEditDistanceTest.assertDistance(3.0, "abxy", "bayx", false);
    }

    private static void assertDistance(double expectedDistance, CharSequence cs1, CharSequence cs2, boolean allowTransposition) {
        WeightedEditDistance distanceMeasure = allowTransposition ? TRANSPOSING_EDIT : NON_TRANSPOSING_EDIT;
        WeightedEditDistanceTest.assertDistance(expectedDistance, cs1, cs2, distanceMeasure, false);
    }

    private static void assertDistance(double expectedDistance, CharSequence cs1, CharSequence cs2, WeightedEditDistance editDistance, boolean isSimilarity) {
        if (isSimilarity) {
            Assert.assertEquals((double)expectedDistance, (double)editDistance.proximity(cs1, cs2), (double)1.0E-4);
        } else {
            Assert.assertEquals((double)expectedDistance, (double)editDistance.distance(cs1, cs2), (double)1.0E-4);
        }
    }

    private static class NonTransposing
    extends WeightedEditDistance {
        private NonTransposing() {
        }

        @Override
        public double matchWeight(char c) {
            return 0.0;
        }

        @Override
        public double deleteWeight(char c) {
            return -1.0;
        }

        @Override
        public double insertWeight(char c) {
            return -1.0;
        }

        @Override
        public double substituteWeight(char c1, char c2) {
            return -1.0;
        }

        @Override
        public double transposeWeight(char c1, char c2) {
            return Double.NEGATIVE_INFINITY;
        }
    }

    private static class Transposing
    extends WeightedEditDistance {
        private Transposing() {
        }

        @Override
        public double matchWeight(char c) {
            return 0.0;
        }

        @Override
        public double deleteWeight(char c) {
            return -1.0;
        }

        @Override
        public double insertWeight(char c) {
            return -1.0;
        }

        @Override
        public double substituteWeight(char c1, char c2) {
            return -1.0;
        }

        @Override
        public double transposeWeight(char c1, char c2) {
            return -1.0;
        }
    }
}

