/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.spell;

import com.aliasi.spell.EditDistance;
import junit.framework.Assert;
import org.junit.Test;

public class EditDistanceTest {
    @Test
    public void testOne() {
        EditDistanceTest.assertDistance(0, "", "", true);
        EditDistanceTest.assertDistance(0, "", "", false);
        EditDistanceTest.assertDistance(1, "a", "", true);
        EditDistanceTest.assertDistance(1, "", "a", true);
        EditDistanceTest.assertDistance(1, "a", "", false);
        EditDistanceTest.assertDistance(1, "", "a", false);
        EditDistanceTest.assertDistance(1, "a", "ab", true);
        EditDistanceTest.assertDistance(1, "ab", "a", true);
        EditDistanceTest.assertDistance(1, "a", "ab", false);
        EditDistanceTest.assertDistance(1, "ab", "a", false);
        EditDistanceTest.assertDistance(1, "ab", "ba", true);
        EditDistanceTest.assertDistance(2, "ab", "ba", false);
        EditDistanceTest.assertDistance(1, "abc", "bac", true);
        EditDistanceTest.assertDistance(1, "abc", "acb", true);
        EditDistanceTest.assertDistance(2, "abc", "bac", false);
        EditDistanceTest.assertDistance(2, "abc", "acb", false);
        EditDistanceTest.assertDistance(1, "abcd", "bacd", true);
        EditDistanceTest.assertDistance(1, "abcd", "acbd", true);
        EditDistanceTest.assertDistance(1, "abcd", "abdc", true);
        EditDistanceTest.assertDistance(2, "dabc", "dbac", false);
        EditDistanceTest.assertDistance(2, "pwnag", "ownage", true);
        EditDistanceTest.assertDistance(2, "pwnag", "ownage", false);
        EditDistanceTest.assertDistance(2, "abxy", "bayx", true);
        EditDistanceTest.assertDistance(3, "abxy", "bayx", false);
    }

    private static void assertDistance(int expectedDistance, CharSequence cs1, CharSequence cs2, boolean allowTransposition) {
        Assert.assertEquals((int)expectedDistance, (int)EditDistance.editDistance(cs1, cs2, allowTransposition));
        EditDistance editDistance = new EditDistance(allowTransposition);
        Assert.assertEquals((double)expectedDistance, (double)editDistance.distance(cs1, cs2), (double)1.0E-4);
        if (allowTransposition) {
            Assert.assertEquals((double)expectedDistance, (double)EditDistance.TRANSPOSING.distance(cs1, cs2), (double)1.0E-4);
        } else {
            Assert.assertEquals((double)expectedDistance, (double)EditDistance.NON_TRANSPOSING.distance(cs1, cs2), (double)1.0E-4);
        }
    }
}

