/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.sentences;

import com.aliasi.sentences.IndoEuropeanSentenceModel;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class IndoEuropeanSentenceModelTest {
    @Test
    public void testSerializable() throws IOException {
        IndoEuropeanSentenceModel model = new IndoEuropeanSentenceModel(true, false);
        IndoEuropeanSentenceModel model2 = (IndoEuropeanSentenceModel)AbstractExternalizable.serializeDeserialize(model);
        junit.framework.Assert.assertEquals((boolean)model.balanceParens(), (boolean)model2.balanceParens());
        junit.framework.Assert.assertEquals((boolean)model.forceFinalStop(), (boolean)model2.forceFinalStop());
    }

    @Test
    public void testBoundaries() {
        this.assertBoundaries(new String[]{"John", "ran", "."}, new String[]{"", " ", "", ""}, new int[]{2});
        this.assertBoundaries(new String[]{"John", "ran", ".", "Hello"}, new String[]{"", " ", "", " ", ""}, new int[]{2});
        this.assertBoundaries(new String[]{"John", "ran", ".", "Hello", "?"}, new String[]{"", " ", "", " ", "", ""}, new int[]{2, 4});
        this.assertBoundaries(new String[]{"Mr", ".", "Smith", "ran", "."}, new String[]{"", "", " ", " ", "", ""}, new int[]{4});
        this.assertBoundaries(new String[]{"Mr", ".", "Smith", "ran", "."}, new String[]{"", "", " ", " ", "", ""}, new int[]{4});
        this.assertBoundaries(new String[]{"Johnson", ",", "etc", ".", "are", "OK", "."}, new String[]{"", "", " ", "", " ", " ", "", " "}, new int[0]);
        this.assertBoundaries(new String[]{"\"", "John", "ran", ".", "\""}, new String[]{"", "", " ", "", "", ""}, new int[]{4});
        this.assertBoundaries(new String[]{"\"", "John", "ran", ".", "\"", "Bill"}, new String[]{"", "", " ", "", " ", "", ""}, new int[]{3});
        this.assertBoundaries(new String[]{"\"", "Hello", "world", ".", "What", "up", "?", "\""}, new String[]{"", "", " ", "", " ", " ", "", "", ""}, new int[]{3, 7});
    }

    private void assertBoundaries(String[] tokens, String[] whitespaces, int[] boundaries) {
        junit.framework.Assert.assertEquals((int)tokens.length, (int)(whitespaces.length - 1));
        IndoEuropeanSentenceModel model = new IndoEuropeanSentenceModel();
        Assert.assertArrayEquals((int[])boundaries, (int[])model.boundaryIndices(tokens, whitespaces));
    }
}

