/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.sentences;

import com.aliasi.sentences.AbstractSentenceModel;
import com.aliasi.test.unit.Asserts;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import org.junit.Test;

public class AbstractSentenceModelTest {
    @Test
    public void testReturns() {
        TestModel model = new TestModel();
        ArrayList<Integer> listExpected = new ArrayList<Integer>();
        listExpected.add(4);
        ArrayList<Integer> listFound = new ArrayList<Integer>();
        model.boundaryIndices(new String[]{"a", "b", "c", "d"}, new String[]{"", "", "", "", ""}, 0, 5, listFound);
        Assert.assertEquals(listExpected, listFound);
        int[] indicesFound = model.boundaryIndices(new String[]{"a", "b", "c", "d"}, new String[]{"", "", "", "", ""});
        Assert.assertEquals((int)1, (int)indicesFound.length);
        Assert.assertEquals((int)3, (int)indicesFound[0]);
        int[] indicesFound2 = ((AbstractSentenceModel)model).boundaryIndices(new String[]{"a", "b", "c", "d"}, new String[]{"", "", "", "", ""}, 2, 2);
        Assert.assertEquals((int)1, (int)indicesFound2.length);
        Assert.assertEquals((int)3, (int)indicesFound2[0]);
    }

    @Test
    public void testExceptions() {
        TestModel model = new TestModel();
        try {
            model.boundaryIndices(new String[]{"a", "b"}, new String[]{"", ""});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            model.boundaryIndices(new String[]{"a", "b"}, new String[]{"", ""}, 0, 2);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            model.boundaryIndices(new String[]{"a"}, new String[]{"", ""}, 1, 1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }

    static class TestModel
    extends AbstractSentenceModel {
        TestModel() {
        }

        public void boundaryIndices(String[] tokens, String[] whitespaces, int start, int length, Collection indices) {
            if (length > 0) {
                indices.add(start + length - 1);
            }
        }
    }
}

