/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.matrix;

import com.aliasi.matrix.ProximityMatrix;
import com.aliasi.test.unit.Asserts;
import junit.framework.Assert;
import org.junit.Test;

public class ProximityMatrixTest {
    @Test
    public void testOne() {
        int j;
        ProximityMatrix matrix = new ProximityMatrix(10);
        int i = 0;
        while (i < 10) {
            j = i + 1;
            while (j < 10) {
                matrix.setValue(i, j, i * j);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            j = 0;
            while (j < 10) {
                if (i == j) {
                    Assert.assertEquals((double)0.0, (double)matrix.value(i, j), (double)1.0E-4);
                } else {
                    Assert.assertEquals((double)(i * j), (double)matrix.value(i, j), (double)1.0E-4);
                }
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testExs() {
        try {
            new ProximityMatrix(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            new ProximityMatrix(7).value(7, 3);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            Asserts.succeed();
        }
        try {
            new ProximityMatrix(7).value(3, 7);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            Asserts.succeed();
        }
        try {
            new ProximityMatrix(7).value(3, -1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            Asserts.succeed();
        }
        try {
            new ProximityMatrix(7).value(-1, 3);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            Asserts.succeed();
        }
    }
}

