/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.lm;

import com.aliasi.io.BitInput;
import com.aliasi.io.BitOutput;
import com.aliasi.lm.BitTrieReader;
import com.aliasi.lm.BitTrieWriter;
import com.aliasi.lm.ScaleTrieReader;
import com.aliasi.lm.TrieCharSeqCounter;
import com.aliasi.test.unit.Asserts;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class ScaleTrieReaderTest {
    @Test
    public void testOne() throws IOException {
        int nGram = 3;
        TrieCharSeqCounter c = new TrieCharSeqCounter(nGram);
        c.incrementSubstrings("abc");
        c.incrementSubstrings("bcd");
        c.incrementSubstrings("cde");
        c.incrementSubstrings("cde");
        c.incrementSubstrings("e");
        c.incrementSubstrings("e");
        c.incrementSubstrings("e");
        c.incrementSubstrings("e");
        String[] tests = new String[]{"abc", "bcd", "cd", "ab", "bc", "e", "de", "a", "b", "c"};
        this.assertScaling(c, 0.1, nGram, tests);
        this.assertScaling(c, 0.3, nGram, tests);
        this.assertScaling(c, 0.6, nGram, tests);
        try {
            this.assertScaling(c, -1.0, nGram, tests);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }

    void assertScaling(TrieCharSeqCounter counter, double scale, int maxNGram, String[] tests) throws IOException {
        TrieCharSeqCounter scaled = ScaleTrieReaderTest.scale(counter, scale, maxNGram);
        int i = 0;
        while (i < tests.length) {
            this.assertScaled(counter, scaled, scale, tests[i]);
            ++i;
        }
    }

    void assertScaled(TrieCharSeqCounter counter, TrieCharSeqCounter scaled, double scale, String s) {
        long count = counter.count(s);
        long expected = Math.round(scale * (double)count);
        long found = scaled.count(s);
        Assert.assertEquals((String)(String.valueOf(s) + " scale=" + scale + " count=" + count + " expected=" + expected + " found=" + found), (long)expected, (long)found);
    }

    static TrieCharSeqCounter scale(TrieCharSeqCounter counter, double scale, int maxNGram) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        BitOutput bitsOut = new BitOutput(bytesOut);
        BitTrieWriter writer = new BitTrieWriter(bitsOut);
        TrieCharSeqCounter.writeCounter(counter, writer, 128);
        bitsOut.flush();
        byte[] bytes = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        BitInput bitsIn = new BitInput(bytesIn);
        BitTrieReader reader = new BitTrieReader(bitsIn);
        ScaleTrieReader scaledReader = new ScaleTrieReader(reader, scale);
        return TrieCharSeqCounter.readCounter(scaledReader, maxNGram);
    }
}

