/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.lm;

import com.aliasi.lm.LanguageModel;
import com.aliasi.lm.NGramProcessLM;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Math;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class NGramProcessLMTest {
    static double lambdaFactor = 4.0;
    static int alphabetSize = 255;
    static char[] ABRACADABRA = "abracadabra".toCharArray();
    static double count = 0.0;
    static char[] A = "a".toCharArray();
    static double numOutcomesNull = 5.0;
    static double aCount = 5.0;
    static double numEventsNull = 11.0;
    static double mlEstimateA = aCount / numEventsNull;
    static double uniformEstimate = 1.0 / (double)alphabetSize;
    static double lambdaNull = numEventsNull / (numEventsNull + lambdaFactor * numOutcomesNull);
    static double estimateA = lambdaNull * mlEstimateA + (1.0 - lambdaNull) * uniformEstimate;
    static char[] B = "b".toCharArray();
    static double bCount = 2.0;
    static double mlEstimateB = bCount / numEventsNull;
    static double estimateB = lambdaNull * mlEstimateB + (1.0 - lambdaNull) * uniformEstimate;
    static char[] AB = "ab".toCharArray();
    static double aContextCount = 4.0;
    static double abCount = 2.0;
    static double numOutcomesA = 3.0;
    static double lambdaA = aContextCount / (aContextCount + lambdaFactor * numOutcomesA);
    static double mlEstimateAB = abCount / aContextCount;
    static double estimateAB = lambdaA * mlEstimateAB + (1.0 - lambdaA) * estimateB;
    static char[] DAB = "dab".toCharArray();
    static double daContextCount = 1.0;
    static double dabCount = 1.0;
    static double numOutcomesDA = 1.0;
    static double lambdaDA = daContextCount / (daContextCount + lambdaFactor * numOutcomesDA);
    static double mlEstimateDAB = 1.0;
    static double estimateDAB = lambdaDA * mlEstimateDAB + (1.0 - lambdaDA) * estimateAB;
    static char[] ZAB = "zab".toCharArray();
    static char[] XDAB = "xdab".toCharArray();

    @Test
    public void testExs() {
        NGramProcessLM lm = new NGramProcessLM(3, 128);
        try {
            lm.log2ConditionalEstimate("");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testOne() throws ClassNotFoundException, IOException {
        NGramProcessLM model = new NGramProcessLM(3, alphabetSize, lambdaFactor);
        model.train(ABRACADABRA, 0, ABRACADABRA.length);
        this.assertModel(model);
    }

    @Test
    public void testA() throws ClassNotFoundException, IOException {
        NGramProcessLM model = new NGramProcessLM(4, 128, 4.0);
        model.train("a");
        double expectedLambda = 0.2;
        Assert.assertEquals((double)Math.log2(expectedLambda * 1.0 + (1.0 - expectedLambda) * 1.0 / 128.0), (double)model.log2ConditionalEstimate("a"), (double)0.005);
        model.train("a");
        expectedLambda = 0.3333333333333333;
        Assert.assertEquals((double)Math.log2(expectedLambda * 1.0 + (1.0 - expectedLambda) * 1.0 / 128.0), (double)model.log2ConditionalEstimate("a"), (double)0.005);
    }

    @Test
    public void testA_AB() {
        NGramProcessLM model = new NGramProcessLM(4, 128, 4.0);
        model.train("a");
        model.train("ab");
        double expectedLambda = 0.2727272727272727;
        double expectedCondA = expectedLambda * 2.0 / 3.0 + (1.0 - expectedLambda) * 1.0 / 128.0;
        Assert.assertEquals((double)Math.log2(expectedCondA), (double)model.log2ConditionalEstimate("a"), (double)5.0E-4);
        double expectedCondB = expectedLambda * 1.0 / 3.0 + (1.0 - expectedLambda) * 1.0 / 128.0;
        Assert.assertEquals((double)Math.log2(expectedCondB), (double)model.log2ConditionalEstimate("b"), (double)5.0E-4);
        double expectedLambdaA = 0.2;
        double expectedCondAB = expectedLambdaA * 1.0 + (1.0 - expectedLambdaA) * expectedCondB;
        Assert.assertEquals((double)Math.log2(expectedCondAB), (double)model.log2ConditionalEstimate("ab"), (double)5.0E-4);
    }

    public void assertModel(NGramProcessLM model) throws IOException, ClassNotFoundException {
        LanguageModel.Conditional serializedModel;
        this.assertConditionalLM(model);
        try {
            LanguageModel.Conditional compiledModel = (LanguageModel.Conditional)AbstractExternalizable.compile(model);
            this.assertConditionalLM(compiledModel);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            Assert.fail((String)e.toString());
        }
        try {
            serializedModel = NGramProcessLMTest.readWrite(model);
            this.assertConditionalLM(serializedModel);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            Assert.fail((String)e.toString());
        }
        try {
            serializedModel = (LanguageModel.Conditional)AbstractExternalizable.serializeDeserialize(model);
            this.assertConditionalLM(serializedModel);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            Assert.fail((String)e.toString());
        }
    }

    public static NGramProcessLM readWrite(NGramProcessLM lm) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        lm.writeTo(bytesOut);
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
        return NGramProcessLM.readFrom(bytesIn);
    }

    public void assertConditionalLM(LanguageModel.Conditional model) throws IOException {
        Assert.assertEquals((double)Math.log2(estimateA), (double)model.log2ConditionalEstimate(A, 0, 1), (double)5.0E-4);
        Assert.assertEquals((double)Math.log2(estimateA), (double)model.log2Estimate(A, 0, 1), (double)5.0E-4);
        Assert.assertEquals((double)Math.log2(estimateB), (double)model.log2ConditionalEstimate(B, 0, 1), (double)5.0E-4);
        Assert.assertEquals((String)"AB", (double)Math.log2(estimateAB), (double)model.log2ConditionalEstimate(AB, 0, 2), (double)5.0E-4);
        Assert.assertEquals((double)model.log2ConditionalEstimate(ZAB, 0, 3), (double)model.log2ConditionalEstimate(AB, 0, 2), (double)5.0E-4);
        Assert.assertEquals((String)"DAB", (double)Math.log2(estimateDAB), (double)model.log2ConditionalEstimate(DAB, 0, 3), (double)5.0E-5);
        Assert.assertEquals((double)Math.log2(estimateDAB), (double)model.log2ConditionalEstimate(XDAB, 0, 4), (double)5.0E-4);
        Assert.assertEquals((double)model.log2ConditionalEstimate(A, 0, 1), (double)model.log2Estimate(A, 0, 1), (double)5.0E-4);
        Assert.assertEquals((double)(model.log2ConditionalEstimate(AB, 0, 1) + model.log2ConditionalEstimate(AB, 0, 2)), (double)model.log2Estimate(AB, 0, 2), (double)5.0E-4);
        Assert.assertEquals((double)(model.log2ConditionalEstimate(DAB, 0, 1) + model.log2ConditionalEstimate(DAB, 0, 2) + model.log2ConditionalEstimate(DAB, 0, 3)), (double)model.log2Estimate(DAB, 0, 3), (double)5.0E-4);
        Assert.assertEquals((double)(model.log2ConditionalEstimate(DAB, 1, 2) + model.log2ConditionalEstimate(DAB, 1, 3)), (double)model.log2Estimate(DAB, 1, 3), (double)5.0E-4);
    }
}

