/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.lm;

import com.aliasi.lm.CompiledNGramBoundaryLM;
import com.aliasi.lm.LanguageModel;
import com.aliasi.lm.NGramBoundaryLM;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Math;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class NGramBoundaryLMTest {
    @Test(expected=IllegalArgumentException.class)
    public void testEx() {
        NGramBoundaryLM lm = new NGramBoundaryLM(3, 128, 4.0, 'a');
        char[] bad = "bad".toCharArray();
        lm.train(bad, 0, 3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEx2() {
        NGramBoundaryLM lm = new NGramBoundaryLM(3, 128, 4.0, 'a');
        lm.train("bad");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEx3() {
        NGramBoundaryLM lm = new NGramBoundaryLM(3, 128, 4.0, 'a');
        char[] bad = "bad".toCharArray();
        lm.log2ConditionalEstimate(bad, 0, 3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEx4() {
        NGramBoundaryLM lm = new NGramBoundaryLM(3, 128, 4.0, 'a');
        lm.log2ConditionalEstimate("bad");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEx5() {
        NGramBoundaryLM lm = new NGramBoundaryLM(3, 128, 4.0, 'a');
        lm.log2ConditionalEstimate("");
    }

    @Test
    public void test() throws ClassNotFoundException, IOException {
        NGramBoundaryLM lm = new NGramBoundaryLM(3, 128, 4.0, 'a');
        char[] bad = "bad".toCharArray();
        CompiledNGramBoundaryLM lmSD = NGramBoundaryLMTest.writeRead(lm);
        Assert.assertTrue((boolean)(lmSD instanceof LanguageModel.Sequence));
        try {
            lmSD.log2ConditionalEstimate(bad, 0, 3);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            lmSD.log2ConditionalEstimate("bad");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            lmSD.log2ConditionalEstimate("");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testNullEsts() throws ClassNotFoundException, IOException {
        NGramBoundaryLM lm = new NGramBoundaryLM(3, 127, 4.0, 'a');
        Assert.assertEquals((double)-7.0, (double)lm.log2Estimate(""), (double)0.005);
        Assert.assertEquals((double)-14.0, (double)lm.log2Estimate("b"), (double)0.005);
        CompiledNGramBoundaryLM lmSD = NGramBoundaryLMTest.writeRead(lm);
        Assert.assertEquals((double)-7.0, (double)lmSD.log2Estimate(""), (double)0.005);
        Assert.assertEquals((double)-14.0, (double)lmSD.log2Estimate("b"), (double)0.005);
    }

    @Test
    public void testSimpleEsts() throws ClassNotFoundException, IOException {
        double lambdaFactor = 4.0;
        NGramBoundaryLM lm = new NGramBoundaryLM(3, 127, lambdaFactor, '\uffff');
        double uniform = 0.0078125;
        lm.train("abcd");
        lm.train("cd");
        double numOutcomesBound = 2.0;
        double extCountBound = 2.0;
        double lambdaBound = extCountBound / (extCountBound + lambdaFactor * numOutcomesBound);
        double numOutcomesEmpty = 5.0;
        double extCountEmpty = 8.0;
        double lambdaEmpty = extCountEmpty / (extCountEmpty + lambdaFactor * numOutcomesEmpty);
        double mlBound = 0.25;
        double pBound = lambdaEmpty * mlBound + (1.0 - lambdaEmpty) * uniform;
        double pTotal = (1.0 - lambdaBound) * pBound;
        Assert.assertEquals((double)Math.log2(pTotal), (double)lm.log2Estimate(""), (double)0.005);
        CompiledNGramBoundaryLM lmSD = NGramBoundaryLMTest.writeRead(lm);
        Assert.assertEquals((double)Math.log2(pTotal), (double)lmSD.log2Estimate(""), (double)0.005);
    }

    public static NGramBoundaryLM serDeser(NGramBoundaryLM model) throws ClassNotFoundException, IOException {
        return (NGramBoundaryLM)AbstractExternalizable.serializeDeserialize(model);
    }

    public static CompiledNGramBoundaryLM writeRead(NGramBoundaryLM model) throws ClassNotFoundException, IOException {
        return (CompiledNGramBoundaryLM)AbstractExternalizable.compile(model);
    }
}

