/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.lm;

import com.aliasi.lm.CharSeqCounter;
import com.aliasi.lm.CharSeqMultiCounter;
import com.aliasi.lm.TrieCharSeqCounter;
import org.junit.Assert;
import org.junit.Test;

public class CharSeqMultiCounterTest {
    @Test(expected=IllegalArgumentException.class)
    public void testEx1() {
        CharSeqCounter[] counters0 = new CharSeqCounter[]{};
        new CharSeqMultiCounter(counters0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEx2() {
        TrieCharSeqCounter counter1 = new TrieCharSeqCounter(3);
        CharSeqCounter[] counters1 = new CharSeqCounter[]{counter1};
        new CharSeqMultiCounter(counters1);
    }

    @Test
    public void testOne() {
        TrieCharSeqCounter counter1 = new TrieCharSeqCounter(3);
        TrieCharSeqCounter counter2 = new TrieCharSeqCounter(5);
        this.assertCounters(counter1, counter2);
    }

    @Test
    public void testReversed() {
        TrieCharSeqCounter counter1 = new TrieCharSeqCounter(3);
        TrieCharSeqCounter counter2 = new TrieCharSeqCounter(5);
        this.assertCounters(counter1, counter2);
    }

    public void assertCounters(TrieCharSeqCounter counter1, TrieCharSeqCounter counter2) {
        CharSeqMultiCounter counter = new CharSeqMultiCounter(counter2, counter1);
        CharSeqMultiCounter counterA = new CharSeqMultiCounter(new CharSeqCounter[]{counter1, counter2});
        char[] cs1 = "acef".toCharArray();
        char[] cs2 = "bdgced".toCharArray();
        counter1.incrementSubstrings(cs1, 0, 4);
        Assert.assertArrayEquals((char[])cs1, (char[])counter.charactersFollowing(cs1, 0, 0));
        Assert.assertArrayEquals((char[])cs1, (char[])counterA.charactersFollowing(cs1, 0, 0));
        Assert.assertArrayEquals((char[])new char[]{'e'}, (char[])counter.charactersFollowing(cs1, 0, 2));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.count(cs1, 0, 4));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count(cs1, 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count(cs1, 0, 2));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count(cs1, 0, 1));
        junit.framework.Assert.assertEquals((long)4L, (long)counter.count(cs1, 0, 0));
        junit.framework.Assert.assertEquals((long)0L, (long)counterA.count(cs1, 0, 4));
        junit.framework.Assert.assertEquals((long)1L, (long)counterA.count(cs1, 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counterA.count(cs1, 0, 2));
        junit.framework.Assert.assertEquals((long)1L, (long)counterA.count(cs1, 0, 1));
        junit.framework.Assert.assertEquals((long)4L, (long)counterA.count(cs1, 0, 0));
        junit.framework.Assert.assertEquals((long)0L, (long)counter.extensionCount(cs1, 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.extensionCount(cs1, 0, 2));
        junit.framework.Assert.assertEquals((long)4L, (long)counter.extensionCount(cs1, 0, 0));
        junit.framework.Assert.assertEquals((long)0L, (long)counterA.extensionCount(cs1, 0, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counterA.extensionCount(cs1, 0, 2));
        junit.framework.Assert.assertEquals((long)4L, (long)counterA.extensionCount(cs1, 0, 0));
        Assert.assertArrayEquals((char[])cs1, (char[])counter.observedCharacters());
        Assert.assertArrayEquals((char[])cs1, (char[])counterA.observedCharacters());
        junit.framework.Assert.assertEquals((int)0, (int)counter.numCharactersFollowing(cs1, 0, 3));
        junit.framework.Assert.assertEquals((int)1, (int)counter.numCharactersFollowing(cs1, 0, 2));
        junit.framework.Assert.assertEquals((int)4, (int)counter.numCharactersFollowing(cs1, 0, 0));
        junit.framework.Assert.assertEquals((int)0, (int)counterA.numCharactersFollowing(cs1, 0, 3));
        junit.framework.Assert.assertEquals((int)1, (int)counterA.numCharactersFollowing(cs1, 0, 2));
        junit.framework.Assert.assertEquals((int)4, (int)counterA.numCharactersFollowing(cs1, 0, 0));
        counter2.incrementSubstrings(cs2, 0, 6);
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count(cs2, 0, 5));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count(cs1, 0, 2));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count(cs2, 3, 5));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count(cs1, 1, 2));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("ef".toCharArray(), 0, 2));
        junit.framework.Assert.assertEquals((long)1L, (long)counter.count("ed".toCharArray(), 0, 2));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.count("e".toCharArray(), 0, 1));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.extensionCount(new char[]{'e'}, 0, 1));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.extensionCount(cs1, 1, 2));
        junit.framework.Assert.assertEquals((long)2L, (long)counter.extensionCount(cs1, 1, 3));
        junit.framework.Assert.assertEquals((long)1L, (long)counterA.count(cs2, 0, 5));
        junit.framework.Assert.assertEquals((long)1L, (long)counterA.count(cs1, 0, 2));
        junit.framework.Assert.assertEquals((long)2L, (long)counterA.count(cs2, 3, 5));
        junit.framework.Assert.assertEquals((long)2L, (long)counterA.count(cs1, 1, 2));
        junit.framework.Assert.assertEquals((long)1L, (long)counterA.count("ef".toCharArray(), 0, 2));
        junit.framework.Assert.assertEquals((long)1L, (long)counterA.count("ed".toCharArray(), 0, 2));
        junit.framework.Assert.assertEquals((long)2L, (long)counterA.count("e".toCharArray(), 0, 1));
        junit.framework.Assert.assertEquals((long)2L, (long)counterA.extensionCount(new char[]{'e'}, 0, 1));
        junit.framework.Assert.assertEquals((long)2L, (long)counterA.extensionCount(cs1, 1, 2));
        junit.framework.Assert.assertEquals((long)2L, (long)counterA.extensionCount(cs1, 1, 3));
        Assert.assertArrayEquals((char[])"abcdefg".toCharArray(), (char[])counter.observedCharacters());
        Assert.assertArrayEquals((char[])"abcdefg".toCharArray(), (char[])counterA.observedCharacters());
        counter2.incrementSubstrings("3317".toCharArray(), 0, 4);
        Assert.assertArrayEquals((char[])"137abcdefg".toCharArray(), (char[])counter.observedCharacters());
        Assert.assertArrayEquals((char[])"137abcdefg".toCharArray(), (char[])counterA.observedCharacters());
        counter1.incrementSubstrings("zyxw".toCharArray(), 0, 4);
        Assert.assertArrayEquals((char[])"137abcdefgwxyz".toCharArray(), (char[])counter.observedCharacters());
        Assert.assertArrayEquals((char[])"137abcdefgwxyz".toCharArray(), (char[])counterA.observedCharacters());
    }
}

