/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.io;

import com.aliasi.io.FileExtensionFilter;
import java.io.File;
import junit.framework.Assert;
import org.junit.Test;

public class FileExtensionFilterTest {
    static final String TEMP_DIRECTORY_SYS_PROPERTY = "java.io.tmpdir";
    static final File TEMP_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));

    static File makeCleanDir(File file) {
        if (file.exists() & !file.isDirectory()) {
            file.delete();
        }
        if (!file.isDirectory()) {
            file.mkdir();
        }
        FileExtensionFilterTest.removeDescendants(file);
        return file;
    }

    static File makeCleanDir(File directory, String name) {
        return FileExtensionFilterTest.makeCleanDir(new File(directory, name));
    }

    static int removeDescendants(File file) {
        if (!file.isDirectory()) {
            return 0;
        }
        int count = 0;
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            count += FileExtensionFilterTest.removeRecursive(files[i]);
            ++i;
        }
        return count;
    }

    static int removeRecursive(File file) {
        if (file == null) {
            return 0;
        }
        int descCount = FileExtensionFilterTest.removeDescendants(file);
        file.delete();
        return descCount + 1;
    }

    @Test
    public void testAll() {
        File fDir = FileExtensionFilterTest.makeCleanDir(TEMP_DIRECTORY, "fnamefilter");
        File fYes1 = new File(fDir, "foo.txt");
        File fYes2 = new File(fDir, "bar.txt");
        File fMaybe = new File(fDir, "foo.tx");
        File fNo = new File(fDir, "foo");
        File fNo2 = new File(fDir, "foo.foo");
        File fNo3 = new File(fDir, "foo.");
        FileExtensionFilter filter1 = new FileExtensionFilter("txt");
        Assert.assertTrue((boolean)filter1.accept(fDir));
        Assert.assertTrue((boolean)filter1.accept(fYes1));
        Assert.assertTrue((boolean)filter1.accept(fYes2));
        Assert.assertFalse((boolean)filter1.accept(fMaybe));
        Assert.assertFalse((boolean)filter1.accept(fNo));
        Assert.assertFalse((boolean)filter1.accept(fNo2));
        Assert.assertFalse((boolean)filter1.accept(fNo3));
        FileExtensionFilter filter1true = new FileExtensionFilter("txt", true);
        Assert.assertTrue((boolean)filter1true.accept(fDir));
        Assert.assertTrue((boolean)filter1true.accept(fYes1));
        Assert.assertTrue((boolean)filter1true.accept(fYes2));
        Assert.assertFalse((boolean)filter1true.accept(fMaybe));
        Assert.assertFalse((boolean)filter1true.accept(fNo));
        Assert.assertFalse((boolean)filter1true.accept(fNo2));
        Assert.assertFalse((boolean)filter1true.accept(fNo3));
        FileExtensionFilter filter1false = new FileExtensionFilter("txt", false);
        Assert.assertFalse((boolean)filter1false.accept(fDir));
        Assert.assertTrue((boolean)filter1false.accept(fYes1));
        Assert.assertTrue((boolean)filter1false.accept(fYes2));
        Assert.assertFalse((boolean)filter1false.accept(fMaybe));
        Assert.assertFalse((boolean)filter1false.accept(fNo));
        Assert.assertFalse((boolean)filter1false.accept(fNo2));
        Assert.assertFalse((boolean)filter1false.accept(fNo3));
        FileExtensionFilter filter2 = new FileExtensionFilter("txt", "tx");
        Assert.assertTrue((boolean)filter2.accept(fDir));
        Assert.assertTrue((boolean)filter2.accept(fYes1));
        Assert.assertTrue((boolean)filter2.accept(fYes2));
        Assert.assertTrue((boolean)filter2.accept(fMaybe));
        Assert.assertFalse((boolean)filter2.accept(fNo));
        Assert.assertFalse((boolean)filter2.accept(fNo2));
        Assert.assertFalse((boolean)filter2.accept(fNo3));
        FileExtensionFilter filter2true = new FileExtensionFilter(new String[]{"txt", "tx"}, true);
        Assert.assertTrue((boolean)filter2true.accept(fDir));
        Assert.assertTrue((boolean)filter2true.accept(fYes1));
        Assert.assertTrue((boolean)filter2true.accept(fYes2));
        Assert.assertTrue((boolean)filter2true.accept(fMaybe));
        Assert.assertFalse((boolean)filter2true.accept(fNo));
        Assert.assertFalse((boolean)filter2true.accept(fNo2));
        Assert.assertFalse((boolean)filter2true.accept(fNo3));
        FileExtensionFilter filter2false = new FileExtensionFilter(new String[]{"txt", "tx"}, false);
        Assert.assertFalse((boolean)filter2false.accept(fDir));
        Assert.assertTrue((boolean)filter2false.accept(fYes1));
        Assert.assertTrue((boolean)filter2false.accept(fYes2));
        Assert.assertTrue((boolean)filter2false.accept(fMaybe));
        Assert.assertFalse((boolean)filter2false.accept(fNo));
        Assert.assertFalse((boolean)filter2false.accept(fNo2));
        Assert.assertFalse((boolean)filter2false.accept(fNo3));
    }
}

