/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.hmm;

import com.aliasi.hmm.HmmCharLmEstimator;
import com.aliasi.hmm.HmmDecoder;
import com.aliasi.tag.ScoredTagging;
import com.aliasi.tag.TagLattice;
import com.aliasi.tag.Tagging;
import com.aliasi.util.FastCache;
import com.aliasi.util.ScoredObject;
import com.aliasi.util.Strings;
import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class HmmDecoderTest {
    static void handle(HmmCharLmEstimator estimator, String[] tokens, String[] whitespaces, String[] tags) {
        Tagging<String> tagging = new Tagging<String>(Arrays.asList(tokens), Arrays.asList(tags));
        estimator.handle(tagging);
    }

    @Test
    public void testCons() {
        HmmCharLmEstimator est = new HmmCharLmEstimator();
        String[] toks1 = new String[]{"John", "ran", "."};
        String[] tags1 = new String[]{"PN", "IV", "."};
        HmmDecoderTest.handle(est, toks1, null, tags1);
        String[] toks2 = new String[]{"Mary", "ran", "."};
        String[] tags2 = new String[]{"PN", "IV", "."};
        HmmDecoderTest.handle(est, toks2, null, tags2);
        String[] toks3 = new String[]{"Fred", "ran", "."};
        String[] tags3 = new String[]{"PN", "IV", "."};
        HmmDecoderTest.handle(est, toks3, null, tags3);
        String[] toks4 = new String[]{"John", "likes", "Mary", "."};
        Object[] tags4 = new String[]{"PN", "TV", "PN", "."};
        HmmDecoderTest.handle(est, toks4, null, (String[])tags4);
        HmmDecoder decoder = new HmmDecoder(est);
        HmmDecoder decoderCached = new HmmDecoder(est, new FastCache<String, double[]>(1000), new FastCache<String, double[]>(1000));
        Assert.assertArrayEquals((Object[])tags4, (Object[])HmmDecoderTest.firstBest(decoder, toks4));
        int i = 0;
        while (i < 5) {
            Assert.assertArrayEquals((Object[])tags4, (Object[])HmmDecoderTest.firstBest(decoderCached, toks4));
            ++i;
        }
        Object[] empty = new String[]{};
        Assert.assertArrayEquals((Object[])empty, (Object[])HmmDecoderTest.firstBest(decoderCached, (String[])empty));
        int i2 = 0;
        while (i2 < 5) {
            Assert.assertArrayEquals((Object[])empty, (Object[])HmmDecoderTest.firstBest(decoderCached, (String[])empty));
            ++i2;
        }
    }

    static String[] firstBest(HmmDecoder decoder, String[] tokens) {
        Tagging<String> tagging = decoder.tag(Arrays.asList(tokens));
        return tagging.tags().toArray(Strings.EMPTY_STRING_ARRAY);
    }

    @Test
    public void testLattice() {
        HmmCharLmEstimator est = new HmmCharLmEstimator();
        String[] toks1 = new String[]{"John", "ran", "."};
        String[] tags1 = new String[]{"PN", "IV", "."};
        HmmDecoderTest.handle(est, toks1, null, tags1);
        String[] toks2 = new String[]{"Mary", "ran", "."};
        String[] tags2 = new String[]{"PN", "IV", "."};
        HmmDecoderTest.handle(est, toks2, null, tags2);
        String[] toks3 = new String[]{"Fred", "ran", "."};
        String[] tags3 = new String[]{"PN", "IV", "."};
        HmmDecoderTest.handle(est, toks3, null, tags3);
        String[] toks4 = new String[]{"John", "likes", "Mary", "."};
        String[] tags4 = new String[]{"PN", "TV", "PN", "."};
        HmmDecoderTest.handle(est, toks4, null, tags4);
        HmmDecoder decoder = new HmmDecoder(est);
        HmmDecoder decoderCached = new HmmDecoder(est, new FastCache<String, double[]>(1000), new FastCache<String, double[]>(1000));
        TagLattice<String> lattice = HmmDecoderTest.lattice(decoder, toks4);
        HmmDecoderTest.lattice(decoderCached, toks4);
        int i = 0;
        while (i < 5) {
            ++i;
        }
        String[] empty = new String[]{};
        lattice = HmmDecoderTest.lattice(decoder, empty);
        int i2 = 0;
        while (i2 < 5) {
            lattice = HmmDecoderTest.lattice(decoderCached, empty);
            ++i2;
        }
    }

    static TagLattice<String> lattice(HmmDecoder decoder, String[] toks) {
        return decoder.tagMarginal(Arrays.asList(toks));
    }

    static Iterator nBest(HmmDecoder decoder, String[] tokens) {
        return HmmDecoderTest.nBest(decoder, tokens, Integer.MAX_VALUE);
    }

    static Iterator nBest(HmmDecoder decoder, String[] tokens, int maxResults) {
        return new IteratorWrapper(decoder.tagNBest(Arrays.asList(tokens), maxResults));
    }

    @Test
    public void testNBest() {
        HmmCharLmEstimator est = new HmmCharLmEstimator();
        String[] toks1 = new String[]{"John", "ran", "."};
        String[] tags1 = new String[]{"PN", "IV", "."};
        HmmDecoderTest.handle(est, toks1, null, tags1);
        String[] toks2 = new String[]{"Mary", "ran", "."};
        String[] tags2 = new String[]{"PN", "IV", "."};
        HmmDecoderTest.handle(est, toks2, null, tags2);
        String[] toks3 = new String[]{"Fred", "ran", "."};
        String[] tags3 = new String[]{"PN", "IV", "."};
        HmmDecoderTest.handle(est, toks3, null, tags3);
        String[] toks4 = new String[]{"John", "likes", "Mary", "."};
        Object[] tags4 = new String[]{"PN", "TV", "PN", "."};
        HmmDecoderTest.handle(est, toks4, null, (String[])tags4);
        HmmDecoder decoder = new HmmDecoder(est);
        HmmDecoder decoderCached = new HmmDecoder(est, new FastCache<String, double[]>(1000), new FastCache<String, double[]>(1000));
        Iterator nBest = HmmDecoderTest.nBest(decoder, toks4);
        ScoredObject best = (ScoredObject)nBest.next();
        Object[] decodedTags = (String[])best.getObject();
        Assert.assertArrayEquals((Object[])tags4, (Object[])decodedTags);
        Iterator nBestC = HmmDecoderTest.nBest(decoderCached, toks4);
        ScoredObject bestC = (ScoredObject)nBestC.next();
        Object[] decodedTagsC = (String[])bestC.getObject();
        Assert.assertArrayEquals((Object[])tags4, (Object[])decodedTagsC);
        String[] tags5 = new String[]{"A", "B", "C", "."};
        HmmDecoderTest.handle(est, toks4, null, tags5);
        nBest = HmmDecoderTest.nBest(decoder, toks4);
        double lastScore = Double.POSITIVE_INFINITY;
        int i = 0;
        while (nBest.hasNext()) {
            ScoredObject nextBest = (ScoredObject)nBest.next();
            double score = nextBest.score();
            junit.framework.Assert.assertTrue((score < lastScore ? 1 : 0) != 0);
            lastScore = score;
            String[] nextTags = (String[])nextBest.getObject();
            junit.framework.Assert.assertEquals((int)4, (int)nextTags.length);
            ++i;
        }
        HmmDecoder decoderCached2 = new HmmDecoder(est, new FastCache<String, double[]>(1000), new FastCache<String, double[]>(1000));
        int k = 0;
        while (k < 5) {
            Iterator nBestC2 = HmmDecoderTest.nBest(decoderCached2, toks4);
            double lastScoreC2 = Double.POSITIVE_INFINITY;
            int i2 = 0;
            while (nBestC2.hasNext()) {
                ScoredObject nextBestC2 = (ScoredObject)nBestC2.next();
                double scoreC2 = nextBestC2.score();
                junit.framework.Assert.assertTrue((scoreC2 < lastScoreC2 ? 1 : 0) != 0);
                lastScoreC2 = scoreC2;
                String[] nextTagsC2 = (String[])nextBestC2.getObject();
                junit.framework.Assert.assertEquals((int)4, (int)nextTagsC2.length);
                ++i2;
            }
            ++k;
        }
        ScoredObject firstBest = (ScoredObject)HmmDecoderTest.nBest(decoder, toks4).next();
        Object[] yield = (String[])firstBest.getObject();
        Assert.assertArrayEquals((Object[])HmmDecoderTest.firstBest(decoder, toks4), (Object[])yield);
        int i3 = 0;
        while (i3 < 5) {
            ScoredObject firstBestC2 = (ScoredObject)HmmDecoderTest.nBest(decoderCached2, toks4).next();
            Object[] yieldC2 = (String[])firstBestC2.getObject();
            Assert.assertArrayEquals((Object[])HmmDecoderTest.firstBest(decoderCached2, toks4), (Object[])yieldC2);
            ++i3;
        }
        String[] empty = new String[]{};
        Iterator nBest2 = HmmDecoderTest.nBest(decoder, empty);
        nBest2.next();
        junit.framework.Assert.assertFalse((boolean)nBest2.hasNext());
        int i4 = 0;
        while (i4 < 5) {
            Iterator nBestC2 = HmmDecoderTest.nBest(decoderCached2, empty);
            nBestC2.next();
            junit.framework.Assert.assertFalse((boolean)nBestC2.hasNext());
            ++i4;
        }
    }

    @Test
    public void testNBestFull() {
        HmmCharLmEstimator est = new HmmCharLmEstimator();
        String[] toks1 = new String[]{"a", "b"};
        String[] tags1 = new String[]{"X", "Y"};
        HmmDecoderTest.handle(est, toks1, null, tags1);
        String[] toks2 = new String[]{"b", "a"};
        HmmDecoderTest.handle(est, toks2, null, tags1);
        String[] toks3 = new String[]{"a", "b"};
        String[] tags3 = new String[]{"Y", "X"};
        HmmDecoderTest.handle(est, toks3, null, tags3);
        String[] toks4 = new String[]{"b", "a"};
        String[] tags4 = new String[]{"Y", "X"};
        HmmDecoderTest.handle(est, toks4, null, tags4);
        String[] toks5 = new String[]{"a", "b"};
        String[] tags5 = new String[]{"X", "X"};
        HmmDecoderTest.handle(est, toks5, null, tags5);
        String[] toks6 = new String[]{"b", "a"};
        String[] tags6 = new String[]{"X", "X"};
        HmmDecoderTest.handle(est, toks6, null, tags6);
        String[] toks7 = new String[]{"a", "b"};
        String[] tags7 = new String[]{"Y", "Y"};
        HmmDecoderTest.handle(est, toks7, null, tags7);
        String[] toks8 = new String[]{"b", "a"};
        String[] tags8 = new String[]{"Y", "Y"};
        HmmDecoderTest.handle(est, toks8, null, tags8);
        HmmDecoder decoder = new HmmDecoder(est);
        this.assertNBestCount(decoder, new String[0], 1);
        this.assertNBestCount(decoder, new String[]{"a"}, 2);
        this.assertNBestCount(decoder, new String[]{"a", "a"}, 4);
        this.assertNBestCount(decoder, new String[]{"a", "a", "a"}, 8);
        this.assertNBestCount(decoder, new String[]{"a", "a", "a", "a"}, 16);
        HmmDecoder decoderCached = new HmmDecoder(est, new FastCache<String, double[]>(1000), new FastCache<String, double[]>(1000));
        int i = 0;
        while (i < 5) {
            this.assertNBestCount(decoderCached, new String[0], 1);
            this.assertNBestCount(decoderCached, new String[]{"a"}, 2);
            this.assertNBestCount(decoderCached, new String[]{"a", "a"}, 4);
            this.assertNBestCount(decoderCached, new String[]{"a", "a", "a"}, 8);
            this.assertNBestCount(decoderCached, new String[]{"a", "a", "a", "a"}, 16);
            ++i;
        }
    }

    void assertNBestCount(HmmDecoder decoder, String[] toks, int expCount) {
        Iterator nBest = HmmDecoderTest.nBest(decoder, toks);
        int count = 0;
        while (nBest.hasNext()) {
            ++count;
            nBest.next();
        }
        junit.framework.Assert.assertEquals((int)expCount, (int)count);
    }

    static class IteratorWrapper
    implements Iterator {
        Iterator<ScoredTagging<String>> mIt;

        public IteratorWrapper(Iterator<ScoredTagging<String>> it) {
            this.mIt = it;
        }

        public Object next() {
            ScoredTagging<String> st = this.mIt.next();
            return new ScoredObject<String[]>(st.tags().toArray(Strings.EMPTY_STRING_ARRAY), st.score());
        }

        @Override
        public boolean hasNext() {
            return this.mIt.hasNext();
        }

        @Override
        public void remove() {
            this.mIt.remove();
        }
    }
}

