/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.hmm;

import com.aliasi.hmm.HiddenMarkovModel;
import com.aliasi.hmm.HmmCharLmEstimator;
import com.aliasi.tag.Tagging;
import com.aliasi.test.unit.Asserts;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Math;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.Assert;
import org.junit.Test;

public class HmmCharLmEstimatorTest {
    public void handle(HmmCharLmEstimator estimator, String[] toks, String[] whitespaces, String[] tags) {
        Tagging<String> tagging = new Tagging<String>(Arrays.asList(toks), Arrays.asList(tags));
        estimator.handle(tagging);
    }

    @Test
    public void testCons() {
        new HmmCharLmEstimator();
        Asserts.succeed();
    }

    @Test
    public void testCons2() {
        Assert.assertNotNull((Object)new HmmCharLmEstimator(5, 256, 4.0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExc1() {
        new HmmCharLmEstimator(0, 256, 4.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExc2() {
        new HmmCharLmEstimator(-1, 256, 4.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExc3() {
        new HmmCharLmEstimator(2, 0, 4.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExc4() {
        new HmmCharLmEstimator(2, -1, 4.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExc5() {
        new HmmCharLmEstimator(2, 1000000, 4.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExc6() {
        new HmmCharLmEstimator(2, 256, -1.0);
    }

    @Test
    public void testStart() throws IOException, ClassNotFoundException {
        HmmCharLmEstimator est = new HmmCharLmEstimator(5, 256, 4.0);
        est.trainStart("a");
        est.trainStart("a");
        est.trainStart("b");
        est.trainStart("a");
        Assert.assertEquals((double)0.75, (double)est.startProb("a"), (double)0.001);
        Assert.assertEquals((double)0.25, (double)est.startProb("b"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)est.startProb("c"), (double)0.001);
        int idA = est.stateSymbolTable().symbolToID("a");
        int idB = est.stateSymbolTable().symbolToID("b");
        Assert.assertEquals((double)est.startProb("a"), (double)est.startProb(idA), (double)1.0E-4);
        Assert.assertEquals((double)est.startProb("b"), (double)est.startProb(idB), (double)1.0E-4);
        Assert.assertEquals((double)est.startLog2Prob("a"), (double)est.startLog2Prob(idA), (double)1.0E-4);
        Assert.assertEquals((double)est.startLog2Prob("b"), (double)est.startLog2Prob(idB), (double)1.0E-4);
        HiddenMarkovModel est2 = (HiddenMarkovModel)AbstractExternalizable.compile(est);
        Assert.assertEquals((double)0.75, (double)est2.startProb("a"), (double)0.001);
        Assert.assertEquals((double)0.25, (double)est2.startProb("b"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)est2.startProb("c"), (double)0.001);
        Assert.assertEquals((double)est2.startProb("a"), (double)est2.startProb(idA), (double)1.0E-4);
        Assert.assertEquals((double)est2.startProb("b"), (double)est2.startProb(idB), (double)1.0E-4);
        Assert.assertEquals((double)est2.startLog2Prob("a"), (double)est2.startLog2Prob(idA), (double)1.0E-4);
        Assert.assertEquals((double)est2.startLog2Prob("b"), (double)est2.startLog2Prob(idB), (double)1.0E-4);
        est = new HmmCharLmEstimator();
        String[] tags1 = new String[]{"a", "b", "c"};
        String[] tags2 = new String[]{"a", "b", "d"};
        String[] tags3 = new String[]{"a", "a", "c"};
        String[] tags4 = new String[]{"b", "a", "a"};
        String[] toks = new String[]{"1", "2", "3"};
        this.handle(est, toks, null, tags1);
        this.handle(est, toks, null, tags2);
        this.handle(est, toks, null, tags3);
        this.handle(est, toks, null, tags4);
        Assert.assertEquals((double)0.75, (double)est.startProb("a"), (double)0.001);
        Assert.assertEquals((double)0.25, (double)est.startProb("b"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)est.startProb("c"), (double)0.001);
        Assert.assertEquals((double)Math.log2(est.startProb("a")), (double)est.startLog2Prob("a"), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(est.startProb("b")), (double)est.startLog2Prob("b"), (double)1.0E-4);
        est2 = (HiddenMarkovModel)AbstractExternalizable.compile(est);
        Assert.assertEquals((double)0.75, (double)est2.startProb("a"), (double)0.001);
        Assert.assertEquals((double)0.25, (double)est2.startProb("b"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)est2.startProb("c"), (double)0.001);
        Assert.assertEquals((double)Math.log2(est2.startProb("a")), (double)est2.startLog2Prob("a"), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(est2.startProb("b")), (double)est2.startLog2Prob("b"), (double)1.0E-4);
    }

    @Test
    public void testEnd() throws IOException, ClassNotFoundException {
        HmmCharLmEstimator est = new HmmCharLmEstimator(5, 256, 4.0);
        est.trainEnd("a");
        est.trainEnd("a");
        est.trainEnd("b");
        est.trainEnd("a");
        Assert.assertEquals((double)0.75, (double)est.endProb("a"), (double)0.001);
        Assert.assertEquals((double)0.25, (double)est.endProb("b"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)est.endProb("c"), (double)0.001);
        int idA = est.stateSymbolTable().symbolToID("a");
        int idB = est.stateSymbolTable().symbolToID("b");
        Assert.assertEquals((double)est.endProb("a"), (double)est.endProb(idA), (double)1.0E-4);
        Assert.assertEquals((double)est.endProb("b"), (double)est.endProb(idB), (double)1.0E-4);
        Assert.assertEquals((double)est.endLog2Prob("a"), (double)est.endLog2Prob(idA), (double)1.0E-4);
        Assert.assertEquals((double)est.endLog2Prob("b"), (double)est.endLog2Prob(idB), (double)1.0E-4);
        HiddenMarkovModel est2 = (HiddenMarkovModel)AbstractExternalizable.compile(est);
        Assert.assertEquals((double)0.75, (double)est2.endProb("a"), (double)0.001);
        Assert.assertEquals((double)0.25, (double)est2.endProb("b"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)est2.endProb("c"), (double)0.001);
        Assert.assertEquals((double)est2.endProb("a"), (double)est2.endProb(idA), (double)1.0E-4);
        Assert.assertEquals((double)est2.endProb("b"), (double)est2.endProb(idB), (double)1.0E-4);
        Assert.assertEquals((double)est2.endLog2Prob("a"), (double)est2.endLog2Prob(idA), (double)1.0E-4);
        Assert.assertEquals((double)est2.endLog2Prob("b"), (double)est2.endLog2Prob(idB), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(est.endProb("a")), (double)est.endLog2Prob("a"), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(est.endProb("b")), (double)est.endLog2Prob("b"), (double)1.0E-4);
        est = new HmmCharLmEstimator();
        String[] tags1 = new String[]{"a", "b", "c"};
        String[] tags2 = new String[]{"a", "b", "d"};
        String[] tags3 = new String[]{"a", "a", "c"};
        String[] tags4 = new String[]{"b", "a", "a"};
        String[] toks = new String[]{"1", "2", "3"};
        this.handle(est, toks, null, tags1);
        this.handle(est, toks, null, tags2);
        this.handle(est, toks, null, tags3);
        this.handle(est, toks, null, tags4);
        Assert.assertEquals((double)0.25, (double)est.endProb("a"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)est.endProb("b"), (double)0.001);
        Assert.assertEquals((double)0.5, (double)est.endProb("c"), (double)0.001);
        Assert.assertEquals((double)0.25, (double)est.endProb("d"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)est.endProb("e"), (double)0.001);
        est2 = (HiddenMarkovModel)AbstractExternalizable.compile(est);
        Assert.assertEquals((double)0.25, (double)est2.endProb("a"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)est2.endProb("b"), (double)0.001);
        Assert.assertEquals((double)0.5, (double)est2.endProb("c"), (double)0.001);
        Assert.assertEquals((double)0.25, (double)est2.endProb("d"), (double)0.001);
        Assert.assertEquals((double)0.0, (double)est2.endProb("e"), (double)0.001);
        Assert.assertEquals((double)Math.log2(est2.endProb("a")), (double)est2.endLog2Prob("a"), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(est2.endProb("b")), (double)est2.endLog2Prob("b"), (double)1.0E-4);
    }

    @Test
    public void testTransitions() throws IOException, ClassNotFoundException {
        HmmCharLmEstimator est = new HmmCharLmEstimator(5, 256, 4.0);
        String[] tags = new String[]{"a", "b", "c", "a", "d", "b"};
        String[] toks = new String[]{"1", "2", "3", "4", "5", "6"};
        this.handle(est, toks, null, tags);
        Assert.assertEquals((double)0.5, (double)est.transitProb("a", "b"), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)est.transitProb("a", "d"), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)est.transitProb("a", "e"), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)est.transitProb("b", "c"), (double)1.0E-4);
        HiddenMarkovModel est2 = (HiddenMarkovModel)AbstractExternalizable.compile(est);
        Assert.assertEquals((double)0.5, (double)est2.transitProb("a", "b"), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)est2.transitProb("a", "d"), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)est2.transitProb("a", "e"), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)est2.transitProb("b", "c"), (double)1.0E-4);
    }

    @Test
    public void testTransitions2() throws IOException, ClassNotFoundException {
        HmmCharLmEstimator est = new HmmCharLmEstimator(5, 256, 4.0);
        String[] toks = new String[]{"a", "b", "c", "d", "e", "f", "g"};
        String[] tags = new String[]{"A", "B", "A", "A", "B", "B", "A"};
        this.handle(est, toks, null, tags);
        Assert.assertEquals((double)0.25, (double)est.transitProb("A", "A"), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)est.transitProb("A", "B"), (double)1.0E-4);
        Assert.assertEquals((double)0.3333, (double)est.transitProb("B", "B"), (double)1.0E-4);
        Assert.assertEquals((double)0.6666, (double)est.transitProb("B", "A"), (double)1.0E-4);
        double[][] transitions = new double[2][2];
        transitions[0][0] = est.transitProb(0, 0);
        transitions[0][1] = est.transitProb(0, 1);
        transitions[1][0] = est.transitProb(1, 0);
        transitions[1][1] = est.transitProb(1, 1);
        int idA = est.stateSymbolTable().symbolToID("A");
        int idB = est.stateSymbolTable().symbolToID("B");
        Assert.assertEquals((double)est.transitProb("A", "B"), (double)est.transitProb(idA, idB), (double)1.0E-4);
        Assert.assertEquals((double)est.transitProb("B", "A"), (double)est.transitProb(idB, idA), (double)1.0E-4);
        Assert.assertEquals((double)est.transitLog2Prob("A", "B"), (double)est.transitLog2Prob(idA, idB), (double)1.0E-4);
        Assert.assertEquals((double)est.transitLog2Prob("B", "A"), (double)est.transitLog2Prob(idB, idA), (double)1.0E-4);
        HiddenMarkovModel est2 = (HiddenMarkovModel)AbstractExternalizable.compile(est);
        Assert.assertEquals((double)0.25, (double)est2.transitProb("A", "A"), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)est2.transitProb("A", "B"), (double)1.0E-4);
        Assert.assertEquals((double)0.3333, (double)est2.transitProb("B", "B"), (double)1.0E-4);
        Assert.assertEquals((double)0.6666, (double)est2.transitProb("B", "A"), (double)1.0E-4);
        Assert.assertEquals((double)est.transitProb("A", "B"), (double)est2.transitProb(idA, idB), (double)1.0E-4);
        Assert.assertEquals((double)est.transitProb("B", "A"), (double)est2.transitProb(idB, idA), (double)1.0E-4);
        Assert.assertEquals((double)est2.transitLog2Prob("A", "B"), (double)est2.transitLog2Prob(idA, idB), (double)1.0E-4);
        Assert.assertEquals((double)est2.transitLog2Prob("B", "A"), (double)est2.transitLog2Prob(idB, idA), (double)1.0E-4);
        Assert.assertEquals((double)est.transitLog2Prob("A", "B"), (double)est2.transitLog2Prob("A", "B"), (double)1.0E-4);
        Assert.assertEquals((double)est.transitLog2Prob("A", "B"), (double)Math.log2(est.transitProb("A", "B")), (double)1.0E-4);
        Assert.assertEquals((double)est2.transitLog2Prob("A", "B"), (double)Math.log2(est2.transitProb("A", "B")), (double)1.0E-4);
    }

    @Test
    public void testEmissions() throws IOException, ClassNotFoundException {
        HmmCharLmEstimator est = new HmmCharLmEstimator(5, 256, 0.01);
        String[] toks = new String[]{"John", "likes", "Mary"};
        String[] tags = new String[]{"N", "V", "N"};
        this.handle(est, toks, null, tags);
        Assert.assertTrue((est.emitProb("N", (CharSequence)"John") > est.emitProb("N", (CharSequence)"xxxxx") ? 1 : 0) != 0);
        Assert.assertTrue((est.emitProb("N", (CharSequence)"John") > est.emitProb("N", (CharSequence)"Jon") ? 1 : 0) != 0);
        Assert.assertTrue((est.emitProb("N", (CharSequence)"John") == est.emitProb("N", (CharSequence)"Mary") ? 1 : 0) != 0);
        Assert.assertTrue((est.emitProb("V", (CharSequence)"liked") == est.emitProb("V", (CharSequence)"liker") ? 1 : 0) != 0);
        Assert.assertEquals((double)Math.log2(est.emitProb("V", (CharSequence)"liked")), (double)est.emitLog2Prob("V", (CharSequence)"liked"), (double)1.0E-4);
        int idN = est.stateSymbolTable().symbolToID("N");
        int idV = est.stateSymbolTable().symbolToID("V");
        Assert.assertEquals((double)est.emitLog2Prob(idV, (CharSequence)"liked"), (double)est.emitLog2Prob("V", (CharSequence)"liked"), (double)1.0E-4);
        Assert.assertEquals((double)est.emitProb("N", (CharSequence)"John"), (double)est.emitProb(idN, (CharSequence)"John"), (double)1.0E-4);
        Assert.assertEquals((double)est.emitProb("V", (CharSequence)"foo"), (double)est.emitProb(idV, (CharSequence)"foo"), (double)1.0E-4);
        double V_lakes = est.emitProb("V", (CharSequence)"lakes");
        double V_likes = est.emitProb("V", (CharSequence)"likes");
        double V_laks = est.emitProb("V", (CharSequence)"laks");
        double V_like = est.emitProb("V", (CharSequence)"like");
        Assert.assertTrue((V_likes > V_lakes ? 1 : 0) != 0);
        Assert.assertTrue((V_likes > V_laks ? 1 : 0) != 0);
        Assert.assertTrue((V_likes > V_like ? 1 : 0) != 0);
        HiddenMarkovModel est2 = (HiddenMarkovModel)AbstractExternalizable.compile(est);
        Assert.assertTrue((est2.emitProb("N", (CharSequence)"John") > est2.emitProb("N", (CharSequence)"xxxxx") ? 1 : 0) != 0);
        Assert.assertTrue((est2.emitProb("N", (CharSequence)"John") > est2.emitProb("N", (CharSequence)"Jon") ? 1 : 0) != 0);
        Assert.assertTrue((est2.emitProb("N", (CharSequence)"John") == est2.emitProb("N", (CharSequence)"Mary") ? 1 : 0) != 0);
        Assert.assertTrue((est2.emitProb("V", (CharSequence)"liked") == est2.emitProb("V", (CharSequence)"liker") ? 1 : 0) != 0);
        V_lakes = est2.emitProb("V", (CharSequence)"lakes");
        V_likes = est2.emitProb("V", (CharSequence)"likes");
        V_laks = est2.emitProb("V", (CharSequence)"laks");
        V_like = est2.emitProb("V", (CharSequence)"like");
        Assert.assertTrue((V_likes > V_lakes ? 1 : 0) != 0);
        Assert.assertTrue((V_likes > V_laks ? 1 : 0) != 0);
        Assert.assertTrue((V_likes > V_like ? 1 : 0) != 0);
        Assert.assertEquals((double)Math.log2(est2.emitProb("V", (CharSequence)"liked")), (double)est2.emitLog2Prob("V", (CharSequence)"liked"), (double)1.0E-4);
    }
}

