/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.features;

import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.features.ZScoreFeatureExtractor;
import com.aliasi.stats.Statistics;
import com.aliasi.test.unit.features.MockFeatureExtractor;
import com.aliasi.test.unit.features.SerializableMockFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.NotSerializableException;
import org.junit.Test;

public class ZScoreFeatureExtractorTest {
    @Test
    public void testZeros() throws IOException {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        mfe.put(1, new String[]{"A", "B"}, new double[]{1.0, 2.0});
        mfe.put(2, new String[]{"B", "C"}, new double[]{1.0, 2.0});
        mfe.put(3, new String[]{"C", "A"}, new double[]{1.0, 2.0});
        MyCorpus corpus = new MyCorpus(1, 2, 3);
        ZScoreFeatureExtractor<Integer> zsfe = new ZScoreFeatureExtractor<Integer>(corpus, mfe);
        double[] xs = new double[]{1.0, 2.0, 0.0};
        double mean = Statistics.mean(xs);
        double dev = Statistics.standardDeviation(xs);
        MockFeatureExtractor.assertFeats(zsfe, 1, new String[]{"A", "B", "C"}, new double[]{(1.0 - mean) / dev, (2.0 - mean) / dev, (0.0 - mean) / dev});
        MockFeatureExtractor.assertFeats(zsfe, 2, new String[]{"A", "B", "C"}, new double[]{(0.0 - mean) / dev, (1.0 - mean) / dev, (2.0 - mean) / dev});
        MockFeatureExtractor.assertFeats(zsfe, 3, new String[]{"A", "B", "C"}, new double[]{(2.0 - mean) / dev, (0.0 - mean) / dev, (1.0 - mean) / dev});
    }

    @Test
    public void testCache() throws IOException {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        mfe.put(1, new String[]{"A", "B", "C"}, new double[]{3.0, 4.0, 3.0});
        mfe.put(2, new String[]{"A", "B", "C"}, new double[]{7.0, 4.0, 3.0});
        mfe.put(3, new String[]{"A", "B", "C"}, new double[]{7.0, -4.0, 3.0});
        mfe.put(4, new String[]{"A", "B", "C"}, new double[]{19.0, -4.0, 3.0});
        mfe.put(5, new String[]{"A", "B", "C", "D"}, new double[]{3.0, 4.0, 3.0, 42.0});
        MyCorpus corpus = new MyCorpus(1, 2, 3, 4);
        ZScoreFeatureExtractor<Integer> zsfe = new ZScoreFeatureExtractor<Integer>(corpus, mfe);
        double[] as = new double[]{3.0, 7.0, 7.0, 19.0};
        double[] bs = new double[]{4.0, 4.0, -4.0, -4.0};
        double[] cs = new double[]{3.0, 3.0, 3.0, 3.0};
        double meanA = Statistics.mean(as);
        double meanB = Statistics.mean(bs);
        double meanC = Statistics.mean(cs);
        double devA = Statistics.standardDeviation(as);
        double devB = Statistics.standardDeviation(bs);
        double devC = Statistics.standardDeviation(cs);
        MockFeatureExtractor.assertFeats(zsfe, 1, new String[]{"A", "B"}, new double[]{(3.0 - meanA) / devA, (4.0 - meanB) / devB});
        MockFeatureExtractor.assertFeats(zsfe, 2, new String[]{"A", "B"}, new double[]{(7.0 - meanA) / devA, (4.0 - meanB) / devB});
        MockFeatureExtractor.assertFeats(zsfe, 3, new String[]{"A", "B"}, new double[]{(7.0 - meanA) / devA, (-4.0 - meanB) / devB});
        MockFeatureExtractor.assertFeats(zsfe, 4, new String[]{"A", "B"}, new double[]{(19.0 - meanA) / devA, (-4.0 - meanB) / devB});
        MockFeatureExtractor.assertFeats(zsfe, 5, new String[]{"A", "B"}, new double[]{(3.0 - meanA) / devA, (4.0 - meanB) / devB});
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        SerializableMockFeatureExtractor mfe = new SerializableMockFeatureExtractor();
        mfe.put(1, new String[]{"A", "B", "C"}, new double[]{3.0, 4.0, 3.0});
        mfe.put(2, new String[]{"A", "B", "C"}, new double[]{7.0, 4.0, 3.0});
        mfe.put(3, new String[]{"A", "B", "C"}, new double[]{7.0, -4.0, 3.0});
        mfe.put(4, new String[]{"A", "B", "C"}, new double[]{19.0, -4.0, 3.0});
        mfe.put(5, new String[]{"A", "B", "C", "D"}, new double[]{3.0, 4.0, 3.0, 42.0});
        MyCorpus corpus = new MyCorpus(1, 2, 3, 4);
        ZScoreFeatureExtractor<Integer> zsfe = new ZScoreFeatureExtractor<Integer>(corpus, mfe);
        FeatureExtractor zsfe2 = (FeatureExtractor)AbstractExternalizable.serializeDeserialize(zsfe);
        double[] as = new double[]{3.0, 7.0, 7.0, 19.0};
        double[] bs = new double[]{4.0, 4.0, -4.0, -4.0};
        double[] cs = new double[]{3.0, 3.0, 3.0, 3.0};
        double meanA = Statistics.mean(as);
        double meanB = Statistics.mean(bs);
        double meanC = Statistics.mean(cs);
        double devA = Statistics.standardDeviation(as);
        double devB = Statistics.standardDeviation(bs);
        double devC = Statistics.standardDeviation(cs);
        MockFeatureExtractor.assertFeats(zsfe2, 1, new String[]{"A", "B"}, new double[]{(3.0 - meanA) / devA, (4.0 - meanB) / devB});
    }

    @Test(expected=NotSerializableException.class)
    public void testUnSerialize() throws IOException, ClassNotFoundException {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        MyCorpus corpus = new MyCorpus(new Integer[0]);
        ZScoreFeatureExtractor<Integer> zsFe = new ZScoreFeatureExtractor<Integer>(corpus, mfe);
        AbstractExternalizable.serializeDeserialize(zsFe);
    }

    static class MyCorpus
    extends Corpus<ObjectHandler<Classified<Integer>>> {
        final Integer[] mItems;

        MyCorpus(Integer ... items) {
            this.mItems = items;
        }

        @Override
        public void visitTrain(ObjectHandler<Classified<Integer>> handler) {
            Integer[] integerArray = this.mItems;
            int n = this.mItems.length;
            int n2 = 0;
            while (n2 < n) {
                Integer item = integerArray[n2];
                Classification c = new Classification("foo");
                Classified<Integer> classified = new Classified<Integer>(item, c);
                handler.handle(classified);
                ++n2;
            }
        }
    }
}

