/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.features;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.features.ChunkerFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class ChunkerFeatureExtractorTest {
    @Test
    public void testNonPhrasal() throws IOException {
        ChunkerFeatureExtractor extractor = new ChunkerFeatureExtractor(new MockChunker(), false);
        FeatureExtractor extractorDeser = (FeatureExtractor)AbstractExternalizable.serializeDeserialize(extractor);
        Map<String, ? extends Number> features = extractor.features("1");
        Assert.assertTrue((boolean)features.isEmpty());
        features = extractorDeser.features("1");
        Assert.assertTrue((boolean)features.isEmpty());
        features = extractor.features("2");
        Assert.assertEquals((int)2, (int)features.size());
        Assert.assertEquals((Object)1.0, (Object)features.get("LOC"));
        Assert.assertEquals((Object)2.0, (Object)features.get("PER"));
        features = extractorDeser.features("2");
        Assert.assertEquals((int)2, (int)features.size());
        Assert.assertEquals((Object)1.0, (Object)features.get("LOC"));
        Assert.assertEquals((Object)2.0, (Object)features.get("PER"));
    }

    @Test
    public void testPhrasal() throws IOException {
        ChunkerFeatureExtractor extractor = new ChunkerFeatureExtractor(new MockChunker(), true);
        FeatureExtractor extractorDeser = (FeatureExtractor)AbstractExternalizable.serializeDeserialize(extractor);
        Map<String, ? extends Number> features = extractor.features("1");
        Assert.assertTrue((boolean)features.isEmpty());
        features = extractorDeser.features("1");
        Assert.assertTrue((boolean)features.isEmpty());
        features = extractor.features("2");
        Assert.assertEquals((int)2, (int)features.size());
        Assert.assertEquals((Object)1.0, (Object)features.get("LOC_Washington"));
        Assert.assertEquals((Object)2.0, (Object)features.get("PER_John"));
        features = extractorDeser.features("2");
        Assert.assertEquals((int)2, (int)features.size());
        Assert.assertEquals((Object)1.0, (Object)features.get("LOC_Washington"));
        Assert.assertEquals((Object)2.0, (Object)features.get("PER_John"));
    }

    static class MockChunker
    implements Chunker,
    Serializable {
        MockChunker() {
        }

        @Override
        public Chunking chunk(char[] cs, int start, int end) {
            return this.chunk(new String(cs, start, end - start));
        }

        @Override
        public Chunking chunk(CharSequence in) {
            if (in.equals("1")) {
                return this.chunking("John ran", new Chunk[0]);
            }
            if (in.equals("2")) {
                return this.chunking("John met John in Washington.", ChunkFactory.createChunk(0, 4, "PER"), ChunkFactory.createChunk(9, 13, "PER"), ChunkFactory.createChunk(17, 27, "LOC"));
            }
            return null;
        }

        Chunking chunking(String text, Chunk ... chunks) {
            ChunkingImpl chunking = new ChunkingImpl(text);
            Chunk[] chunkArray = chunks;
            int n = chunks.length;
            int n2 = 0;
            while (n2 < n) {
                Chunk chunk = chunkArray[n2];
                chunking.add(chunk);
                ++n2;
            }
            return chunking;
        }
    }
}

