/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.features;

import com.aliasi.features.CacheFeatureExtractor;
import com.aliasi.test.unit.features.MockFeatureExtractor;
import com.aliasi.test.unit.features.SerializableMockFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.HashMap;
import org.junit.Test;

public class CacheFeatureExtractorTest {
    @Test
    public void testCache() {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        mfe.put(1, new String[]{"A", "B"}, new double[]{10.0, 2.0});
        mfe.put(2, new String[]{"C"}, new double[]{-50.0});
        CacheFeatureExtractor<Integer> cfe = new CacheFeatureExtractor<Integer>(mfe, new HashMap());
        MockFeatureExtractor.assertFeats(cfe, 1, new String[]{"A", "B"}, new double[]{10.0, 2.0});
        MockFeatureExtractor.assertFeats(cfe, 1, new String[]{"A", "B"}, new double[]{10.0, 2.0});
        MockFeatureExtractor.assertFeats(cfe, 2, new String[]{"C"}, new double[]{-50.0});
        MockFeatureExtractor.assertFeats(cfe, 2, new String[]{"C"}, new double[]{-50.0});
        MockFeatureExtractor.assertFeats(cfe, 1, new String[]{"A", "B"}, new double[]{10.0, 2.0});
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        SerializableMockFeatureExtractor mfe = new SerializableMockFeatureExtractor();
        mfe.put(1, new String[]{"A", "B"}, new double[]{10.0, 2.0});
        mfe.put(2, new String[]{"C"}, new double[]{-50.0});
        CacheFeatureExtractor<Integer> cfe = new CacheFeatureExtractor<Integer>(mfe, new HashMap());
        MockFeatureExtractor.assertFeats(cfe, 1, new String[]{"A", "B"}, new double[]{10.0, 2.0});
        FeatureExtractor cfe2 = (FeatureExtractor)AbstractExternalizable.serializeDeserialize(cfe);
        MockFeatureExtractor.assertFeats(cfe2, 1, new String[]{"A", "B"}, new double[]{10.0, 2.0});
        MockFeatureExtractor.assertFeats(cfe, 2, new String[]{"C"}, new double[]{-50.0});
    }

    @Test(expected=NotSerializableException.class)
    public void testUnSerialize() throws IOException, ClassNotFoundException {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        CacheFeatureExtractor<Integer> cacheFe = new CacheFeatureExtractor<Integer>(mfe, new HashMap());
        AbstractExternalizable.serializeDeserialize(cacheFe);
    }
}

