/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.features;

import com.aliasi.features.BoundedFeatureExtractor;
import com.aliasi.test.unit.features.MockFeatureExtractor;
import com.aliasi.test.unit.features.SerializableMockFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.ObjectToDoubleMap;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class BoundedFeatureExtractorTest {
    @Test
    public void testBounds() {
        ObjectToDoubleMap<String> feats1 = new ObjectToDoubleMap<String>();
        feats1.put("A", 10.0);
        feats1.put("B", 2.0);
        feats1.put("C", -50.0);
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        mfe.put(1, feats1);
        BoundedFeatureExtractor<Integer> boundFe = new BoundedFeatureExtractor<Integer>(mfe, 1.0, 3.0);
        Map<String, Number> feats = boundFe.features(1);
        Assert.assertEquals((Object)3.0, (Object)feats.get("A"));
        Assert.assertEquals((Object)2.0, (Object)feats.get("B"));
        Assert.assertEquals((Object)1.0, (Object)feats.get("C"));
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        ObjectToDoubleMap<String> feats1 = new ObjectToDoubleMap<String>();
        feats1.put("A", 10.0);
        feats1.put("B", 2.0);
        feats1.put("C", -50.0);
        SerializableMockFeatureExtractor mfe = new SerializableMockFeatureExtractor();
        mfe.put(1, feats1);
        BoundedFeatureExtractor<Integer> boundFe = new BoundedFeatureExtractor<Integer>(mfe, 1.0, 3.0);
        FeatureExtractor boundFe2 = (FeatureExtractor)AbstractExternalizable.serializeDeserialize(boundFe);
        Map<String, Number> feats = boundFe2.features(1);
        Assert.assertEquals((Object)3.0, (Object)feats.get("A"));
        Assert.assertEquals((Object)2.0, (Object)feats.get("B"));
        Assert.assertEquals((Object)1.0, (Object)feats.get("C"));
    }

    @Test(expected=NotSerializableException.class)
    public void testUnSerialize() throws IOException, ClassNotFoundException {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        BoundedFeatureExtractor<Integer> boundFe = new BoundedFeatureExtractor<Integer>(mfe, 1.0, 3.0);
        AbstractExternalizable.serializeDeserialize(boundFe);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testE1() {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        new BoundedFeatureExtractor<Integer>(mfe, 1.0, 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testE2() {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        new BoundedFeatureExtractor<Integer>(mfe, Double.POSITIVE_INFINITY, 2.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testE3() {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        new BoundedFeatureExtractor<Integer>(mfe, 15.0, Double.NEGATIVE_INFINITY);
    }
}

