/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.features;

import com.aliasi.features.AddFeatureExtractor;
import com.aliasi.test.unit.features.MockFeatureExtractor;
import com.aliasi.test.unit.features.SerializableMockFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.ObjectToDoubleMap;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class AddFeatureExtractorTest {
    @Test
    public void testAdd() {
        MockFeatureExtractor me1 = new MockFeatureExtractor();
        me1.put(1, new String[]{"a", "b"}, new double[]{1.0, 2.0});
        me1.put(2, new String[]{"a", "c"}, new double[]{10.0, 30.0});
        me1.put(3, new String[]{"a", "d"}, new double[]{100.0, -1.0});
        MockFeatureExtractor me2 = new MockFeatureExtractor();
        me2.put(1, new String[]{"a", "c"}, new double[]{10.0, 30.0});
        MockFeatureExtractor me3 = new MockFeatureExtractor();
        me3.put(1, new String[]{"a", "d"}, new double[]{100.0, -1.0});
        me3.put(3, new String[]{"a", "d"}, new double[]{100.0, -1.0});
        ArrayList<MockFeatureExtractor> extractorList = new ArrayList<MockFeatureExtractor>();
        extractorList.add(me1);
        extractorList.add(me2);
        AddFeatureExtractor<Integer> fe1 = new AddFeatureExtractor<Integer>(extractorList);
        AddFeatureExtractor<Integer> fe2 = new AddFeatureExtractor<Integer>(me1, me2);
        Map<String, Number> feats1X = fe1.features(1);
        Assert.assertEquals((double)11.0, (double)feats1X.get("a").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)feats1X.get("b").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)30.0, (double)feats1X.get("c").doubleValue(), (double)1.0E-4);
        Map<String, Number> feats2X = fe2.features(1);
        Assert.assertEquals((double)11.0, (double)feats2X.get("a").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)feats2X.get("b").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)30.0, (double)feats2X.get("c").doubleValue(), (double)1.0E-4);
        extractorList.add(me3);
        Assert.assertEquals((double)11.0, (double)feats1X.get("a").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)feats1X.get("b").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)30.0, (double)feats1X.get("c").doubleValue(), (double)1.0E-4);
        AddFeatureExtractor<Integer> fe3 = new AddFeatureExtractor<Integer>(extractorList);
        Map<String, Number> feats3X = fe3.features(1);
        Assert.assertEquals((double)111.0, (double)feats3X.get("a").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)feats3X.get("b").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)30.0, (double)feats3X.get("c").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)-1.0, (double)feats3X.get("d").doubleValue(), (double)1.0E-4);
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        ObjectToDoubleMap<String> feats1 = new ObjectToDoubleMap<String>();
        feats1.set("a", 1.0);
        feats1.set("b", 2.0);
        ObjectToDoubleMap<String> feats2 = new ObjectToDoubleMap<String>();
        feats2.set("a", 10.0);
        feats2.set("c", 30.0);
        ObjectToDoubleMap<String> feats3 = new ObjectToDoubleMap<String>();
        feats3.set("a", 100.0);
        feats3.set("d", -1.0);
        SerializableMockFeatureExtractor me1 = new SerializableMockFeatureExtractor();
        me1.put(1, feats1);
        me1.put(2, feats2);
        me1.put(3, feats3);
        SerializableMockFeatureExtractor me2 = new SerializableMockFeatureExtractor();
        me2.put(1, feats2);
        AddFeatureExtractor<Integer> fe1 = new AddFeatureExtractor<Integer>(me1, me2);
        Map<String, Number> feats1X = fe1.features(1);
        Assert.assertEquals((double)11.0, (double)feats1X.get("a").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)feats1X.get("b").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)30.0, (double)feats1X.get("c").doubleValue(), (double)1.0E-4);
        AddFeatureExtractor fe2 = (AddFeatureExtractor)AbstractExternalizable.serializeDeserialize(fe1);
        Map<String, Number> feats2X = fe2.features(1);
        Assert.assertNotNull(feats2X);
        Assert.assertEquals((double)11.0, (double)feats2X.get("a").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)feats2X.get("b").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)30.0, (double)feats2X.get("c").doubleValue(), (double)1.0E-4);
    }

    @Test(expected=NotSerializableException.class)
    public void testNotSerialize() throws IOException, ClassNotFoundException {
        MockFeatureExtractor me1 = new MockFeatureExtractor();
        MockFeatureExtractor me2 = new MockFeatureExtractor();
        AddFeatureExtractor<Integer> afe = new AddFeatureExtractor<Integer>(me1, me2);
        AbstractExternalizable.serializeDeserialize(afe);
    }
}

