/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.dict;

import com.aliasi.dict.DictionaryEntry;
import com.aliasi.dict.MapDictionary;
import com.aliasi.util.AbstractExternalizable;
import java.util.HashSet;
import junit.framework.Assert;
import org.junit.Test;

public class MapDictionaryTest {
    @Test
    public void testOne() throws Exception {
        MapDictionary<String> dict = new MapDictionary<String>();
        this.assertCompile(dict);
        Assert.assertEquals((int)0, (int)dict.size());
        DictionaryEntry<String> entry1 = new DictionaryEntry<String>("foo", "X1");
        dict.addEntry(entry1);
        this.assertCompile(dict);
        Assert.assertEquals((int)1, (int)dict.size());
        DictionaryEntry<String> entry2 = new DictionaryEntry<String>("bar", "Y2");
        dict.addEntry(entry2);
        this.assertCompile(dict);
        DictionaryEntry<String> entry3 = new DictionaryEntry<String>("bar", "Z3");
        dict.addEntry(entry3);
        this.assertCompile(dict);
        Assert.assertEquals((int)3, (int)dict.size());
        HashSet<DictionaryEntry<String>> fooSet = new HashSet<DictionaryEntry<String>>();
        fooSet.add(entry1);
        Assert.assertEquals(fooSet, new HashSet(dict.phraseEntryList("foo")));
        HashSet<DictionaryEntry<String>> barSet = new HashSet<DictionaryEntry<String>>();
        barSet.add(entry2);
        barSet.add(entry3);
        Assert.assertEquals(barSet, new HashSet(dict.phraseEntryList("bar")));
        Assert.assertEquals((int)3, (int)dict.size());
    }

    void assertCompile(MapDictionary dictionary) throws Exception {
        MapDictionary compiledDictionary = (MapDictionary)AbstractExternalizable.compile(dictionary);
        Assert.assertEquals((Object)dictionary, (Object)compiledDictionary);
    }
}

