/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.crf;

import com.aliasi.crf.ForwardBackwardTagLattice;
import com.aliasi.symbol.SymbolTable;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class ForwardBackwardTagLatticeTest {
    @Test
    public void testInputsSyms() {
        ForwardBackwardTagLattice<Object> lattice = new ForwardBackwardTagLattice<Object>(Arrays.asList(new Object[0]), Arrays.asList("NP", "IV"), new double[0][0], new double[0][0], new double[0][0][0], 0.0);
        Assert.assertEquals((int)0, (int)lattice.numTokens());
        Assert.assertEquals((int)2, (int)lattice.numTags());
        Assert.assertEquals((String)"NP", (String)lattice.tag(0));
        Assert.assertEquals((String)"IV", (String)lattice.tag(1));
        Assert.assertEquals(Arrays.asList(new Object[0]), lattice.tokenList());
        SymbolTable tagSymbolTable = lattice.tagSymbolTable();
        Assert.assertEquals((int)0, (int)tagSymbolTable.symbolToID("NP"));
        Assert.assertEquals((int)1, (int)tagSymbolTable.symbolToID("IV"));
        Assert.assertEquals((int)2, (int)tagSymbolTable.numSymbols());
        Assert.assertEquals((String)"NP", (String)tagSymbolTable.idToSymbol(0));
        Assert.assertEquals((String)"IV", (String)tagSymbolTable.idToSymbol(1));
        List<String> tagList = Arrays.asList("NP", "IV");
        Assert.assertEquals(tagList, lattice.tagList());
    }

    @Test
    public void testGetters() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        Assert.assertEquals((int)2, (int)lattice.numTokens());
        Assert.assertEquals(Arrays.asList("John", "ran"), lattice.tokenList());
        Assert.assertEquals((String)"John", (String)lattice.token(0));
        Assert.assertEquals((String)"ran", (String)lattice.token(1));
        Assert.assertEquals((double)-1.0, (double)lattice.logForward(0, 0), (double)1.0E-4);
        Assert.assertEquals((double)-2.0, (double)lattice.logForward(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)-3.0, (double)lattice.logBackward(0, 0), (double)1.0E-4);
        Assert.assertEquals((double)-4.0, (double)lattice.logBackward(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)-5.0, (double)lattice.logTransition(0, 0, 0), (double)1.0E-4);
        Assert.assertEquals((double)-6.0, (double)lattice.logZ(), (double)1.0E-5);
    }

    @Test
    public void testProbs() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP", "VP"), new double[][]{{-1.0, -3.0}, {-2.0, -0.5}}, new double[][]{{-2.5, -5.0}, {-10.0, -3.0}}, new double[][][]{new double[][]{{-1.7, -2.91}, {-5.0, -13.2}}}, -2.0);
        Assert.assertEquals((double)-1.5, (double)lattice.logProbability(0, 0), (double)1.0E-4);
        Assert.assertEquals((double)-6.0, (double)lattice.logProbability(0, 1), (double)1.0E-4);
        Assert.assertEquals((double)-10.0, (double)lattice.logProbability(1, 0), (double)1.0E-4);
        Assert.assertEquals((double)-1.5, (double)lattice.logProbability(1, 1), (double)1.0E-4);
        Assert.assertEquals((double)-10.7, (double)lattice.logProbability(0, new int[2]), (double)1.0E-4);
        int[] nArray = new int[2];
        nArray[1] = 1;
        Assert.assertEquals((double)-4.91, (double)lattice.logProbability(0, nArray), (double)1.0E-4);
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        Assert.assertEquals((double)-16.0, (double)lattice.logProbability(0, nArray2), (double)1.0E-4);
        Assert.assertEquals((double)-17.2, (double)lattice.logProbability(0, new int[]{1, 1}), (double)1.0E-4);
    }

    @Test
    public void testConsLenOK() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP", "IV"), new double[2][2], new double[2][2], new double[1][2][2], 0.0);
        Assert.assertNotNull(lattice);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExLen1() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP", "IV"), new double[3][2], new double[3][2], new double[2][2][2], 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExLen2() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP", "IV"), new double[2][3], new double[2][3], new double[1][3][3], 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExLenA1() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP", "IV"), new double[3][2], new double[2][2], new double[1][2][2], 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExLenA2() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP", "IV"), new double[2][3], new double[2][2], new double[1][2][2], 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExLenA3() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP", "IV"), new double[2][2], new double[3][2], new double[1][2][2], 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExLenA4() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP", "IV"), new double[2][2], new double[2][3], new double[1][2][2], 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExLenA5() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP", "IV"), new double[2][2], new double[2][2], new double[3][2][2], 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExLenA6() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP", "IV"), new double[2][2], new double[2][2], new double[1][3][2], 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExLenA7() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP", "IV"), new double[2][2], new double[2][2], new double[1][2][3], 0.0);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange1() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logForward(2, 0);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange2() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logForward(0, 1);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange3() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logBackward(2, 0);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange4() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logBackward(0, 2);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange5() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logTransition(1, 0, 0);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange6() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logTransition(0, 1, 0);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange7() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logTransition(0, 0, 1);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange8() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logProbability(0, 1);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange9() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logProbability(2, 0);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange10() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logProbability(0, new int[3]);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange11() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logProbability(0, new int[0]);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange12() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logProbability(0, new int[]{1});
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange13() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logProbability(0, 1);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange14() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logProbability(2, 0);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange15() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logProbability(0, new int[3]);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange16() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logProbability(0, new int[0]);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRange17() {
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Arrays.asList("John", "ran"), Arrays.asList("NP"), new double[][]{{-1.0}, {-2.0}}, new double[][]{{-3.0}, {-4.0}}, new double[][][]{new double[][]{{-5.0}}}, -6.0);
        lattice.logProbability(0, new int[]{1});
    }
}

