/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.coref;

import com.aliasi.coref.CachedMention;
import com.aliasi.coref.MentionChainImpl;
import com.aliasi.coref.matchers.EntityTypeMatch;
import com.aliasi.coref.matchers.ExactPhraseMatch;
import com.aliasi.coref.matchers.GenderKiller;
import com.aliasi.coref.matchers.HonorificConflictKiller;
import com.aliasi.coref.matchers.SequenceSubstringMatch;
import com.aliasi.coref.matchers.SynonymMatch;
import java.util.HashSet;
import junit.framework.Assert;
import org.junit.Test;

public class MentionChainImplTest {
    @Test
    public void testOne() {
        String phrase = "Mr. John Smith";
        String entityType = "PERSON";
        HashSet<String> honorifics = new HashSet<String>();
        honorifics.add("mr");
        String gender = null;
        boolean isPronominal = false;
        String[] normalTokens = new String[]{"john", "smith"};
        CachedMention m1 = new CachedMention(phrase, entityType, honorifics, normalTokens, gender, isPronominal);
        MentionChainImpl mc = new MentionChainImpl(m1, 7, 0);
        Assert.assertNotNull((Object)mc);
        Object[] matchers = mc.matchers();
        Class[] matcherClasses = new Class[]{ExactPhraseMatch.class, EntityTypeMatch.class, EntityTypeMatch.class, SequenceSubstringMatch.class, SynonymMatch.class};
        this.assertArrayClass(matchers, matcherClasses);
        Object[] killers = mc.killers();
        Class[] killerClasses = new Class[]{GenderKiller.class, HonorificConflictKiller.class};
        this.assertArrayClass(killers, killerClasses);
        HashSet<CachedMention> expectedMentions = new HashSet<CachedMention>();
        expectedMentions.add(m1);
        Assert.assertEquals(expectedMentions, mc.mentions());
        Assert.assertEquals(honorifics, mc.honorifics());
        Assert.assertNull((Object)mc.gender());
        Assert.assertEquals((int)7, (int)mc.maxSentenceOffset());
        Assert.assertEquals((String)"PERSON", (String)mc.entityType());
        Assert.assertEquals((int)0, (int)mc.identifier());
        String phrase2 = "Dr. John Joseph Smith";
        String entityType2 = "PERSON";
        HashSet<String> honorifics2 = new HashSet<String>();
        honorifics2.add("dr");
        String gender2 = null;
        boolean isPronominal2 = false;
        String[] normalTokens2 = new String[]{"john", "joseph", "smith"};
        CachedMention m2 = new CachedMention(phrase2, entityType2, honorifics2, normalTokens2, gender2, isPronominal2);
        mc.add(m2, 9);
        expectedMentions.add(m2);
        Assert.assertEquals(expectedMentions, mc.mentions());
        this.assertArrayClass(mc.matchers(), matcherClasses);
        this.assertArrayClass(mc.killers(), killerClasses);
        HashSet<String> expectedHonorifics = new HashSet<String>();
        expectedHonorifics.add("mr");
        expectedHonorifics.add("dr");
        Assert.assertEquals(expectedHonorifics, mc.honorifics());
        Assert.assertNull((Object)mc.gender());
        Assert.assertEquals((int)9, (int)mc.maxSentenceOffset());
        Assert.assertEquals((String)"PERSON", (String)mc.entityType());
        Assert.assertEquals((int)0, (int)mc.identifier());
        String phrase3 = "He";
        String entityType3 = "MALE_PRONOUN";
        HashSet<String> honorifics3 = new HashSet<String>();
        String gender3 = "male";
        boolean isPronominal3 = true;
        String[] normalTokens3 = new String[]{"he"};
        CachedMention m3 = new CachedMention(phrase3, entityType3, honorifics3, normalTokens3, gender3, isPronominal3);
        mc.add(m3, 9);
        expectedMentions.add(m3);
        Assert.assertEquals(expectedMentions, mc.mentions());
        Class[] matcherClasses2 = new Class[]{ExactPhraseMatch.class, EntityTypeMatch.class, SequenceSubstringMatch.class, SynonymMatch.class};
        this.assertArrayClass(mc.matchers(), matcherClasses2);
        this.assertArrayClass(mc.killers(), killerClasses);
        Assert.assertEquals(expectedHonorifics, mc.honorifics());
        Assert.assertEquals((String)"male", (String)mc.gender());
        Assert.assertEquals((int)9, (int)mc.maxSentenceOffset());
        Assert.assertEquals((String)"PERSON", (String)mc.entityType());
        Assert.assertEquals((int)0, (int)mc.identifier());
        Assert.assertEquals((int)1, (int)new MentionChainImpl(m2, 17, 1).identifier());
        Assert.assertEquals((int)2, (int)new MentionChainImpl(m2, 19, 2).identifier());
        String phrase4 = "He";
        String entityType4 = "MALE_PRONOUN";
        HashSet<String> honorifics4 = new HashSet<String>();
        String gender4 = "male";
        boolean isPronominal4 = true;
        String[] normalTokens4 = new String[]{"he"};
        CachedMention m4 = new CachedMention(phrase4, entityType4, honorifics4, normalTokens4, gender4, isPronominal4);
        Assert.assertFalse((boolean)mc.killed(m4));
        Assert.assertEquals((int)1, (int)mc.matchScore(m4));
        String phrase5 = "Dr. John Joseph Smith";
        String entityType5 = "PERSON";
        HashSet<String> honorifics5 = new HashSet<String>();
        honorifics5.add("dr");
        String gender5 = null;
        boolean isPronominal5 = false;
        String[] normalTokens5 = new String[]{"john", "joseph", "smith"};
        CachedMention m5 = new CachedMention(phrase5, entityType5, honorifics5, normalTokens5, gender5, isPronominal5);
        Assert.assertEquals((int)1, (int)mc.matchScore(m5));
        String phrase6 = "she";
        String entityType6 = "FEMALE_PRONOUN";
        HashSet<String> honorifics6 = new HashSet<String>();
        String gender6 = null;
        boolean isPronominal6 = true;
        String[] normalTokens6 = new String[]{"she"};
        CachedMention m6 = new CachedMention(phrase6, entityType6, honorifics6, normalTokens6, gender6, isPronominal6);
        Assert.assertEquals((int)-1, (int)mc.matchScore(m6));
        String phrase7 = "Mrs. Johanna Smith";
        String entityType7 = "PERSON";
        HashSet<String> honorifics7 = new HashSet<String>();
        honorifics7.add("mrs");
        String gender7 = null;
        boolean isPronominal7 = false;
        String[] normalTokens7 = new String[]{"johanna", "smith"};
        CachedMention m7 = new CachedMention(phrase7, entityType7, honorifics7, normalTokens7, gender7, isPronominal7);
        Assert.assertTrue((boolean)mc.killed(m7));
        String phrase8 = "Johanna Smith";
        String entityType8 = "PERSON";
        HashSet<String> honorifics8 = new HashSet<String>();
        String gender8 = "female";
        boolean isPronominal8 = false;
        String[] normalTokens8 = new String[]{"johanna", "smith"};
        CachedMention m8 = new CachedMention(phrase8, entityType8, honorifics8, normalTokens8, gender8, isPronominal8);
        Assert.assertTrue((boolean)mc.killed(m8));
    }

    private void assertArrayClass(Object[] xs, Class[] cs) {
        Assert.assertEquals((String)"Expected same length.", (int)xs.length, (int)cs.length);
        int i = 0;
        while (i < xs.length) {
            Assert.assertEquals((String)("Expected class=" + cs[i] + " Found class=" + xs[i].getClass()), xs[i].getClass(), (Object)cs[i]);
            ++i;
        }
    }
}

