/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.classify;

import com.aliasi.classify.DynamicLMClassifier;
import com.aliasi.classify.LMClassifier;
import com.aliasi.lm.NGramBoundaryLM;
import com.aliasi.lm.NGramProcessLM;
import com.aliasi.lm.TokenizedLM;
import com.aliasi.stats.MultivariateEstimator;
import com.aliasi.tokenizer.RegExTokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Files;
import com.aliasi.util.Strings;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DynamicLMClassifierTest {
    @Test(expected=IllegalArgumentException.class)
    public void testLargeCategorySet() throws IOException, ClassNotFoundException {
        RegExTokenizerFactory factory = new RegExTokenizerFactory("\\S+");
        String[] categories = new String[]{"1", "2", "2"};
        DynamicLMClassifier<TokenizedLM> classifier = DynamicLMClassifier.createTokenized(categories, factory, 2);
    }

    @Ignore
    @Test
    public void testCompileOneCategory() throws IOException, ClassNotFoundException {
        File dataFile = new File("src/com/aliasi/test/unit/classify/testFile1.txt");
        String data = Files.readFromFile(dataFile, Strings.UTF8);
        String[] categories = new String[]{"Foo", "Bar"};
        DynamicLMClassifier<NGramBoundaryLM> classifier = DynamicLMClassifier.createNGramBoundary(categories, 32);
        classifier.train("Foo", data, 1);
        LMClassifier compiledClassifier = (LMClassifier)AbstractExternalizable.compile(classifier);
        Assert.assertTrue((compiledClassifier != null ? 1 : 0) != 0);
    }

    @Test
    public void testOne() throws IOException, ClassNotFoundException {
        String[] categories = new String[]{"Foo", "Bar"};
        DynamicLMClassifier<NGramProcessLM> classifier = DynamicLMClassifier.createNGramProcess(categories, 2);
        String oneStr = "The rain in Spain falls mainly on the ground.";
        char[] oneChar = oneStr.toCharArray();
        classifier.train("Foo", new String(oneChar, 0, oneChar.length), 1);
        String barStr = "The rain in Madrid is made of water.";
        char[] barChar = barStr.toCharArray();
        classifier.train("Bar", new String(barChar, 0, barChar.length), 1);
        MultivariateEstimator est = (MultivariateEstimator)classifier.categoryDistribution();
        Assert.assertEquals((long)2L, (long)est.getCount(est.outcome("Foo")));
        Assert.assertEquals((long)4L, (long)est.trainingSampleCount());
        Assert.assertEquals((String)"Foo", (String)classifier.classify("falls mainly").bestCategory());
        Assert.assertEquals((String)"Bar", (String)classifier.classify("Madrid is made of water").bestCategory());
        LMClassifier compiledCassifier = (LMClassifier)AbstractExternalizable.compile(classifier);
        Assert.assertEquals((String)"Foo", (String)compiledCassifier.classify("falls mainly").bestCategory());
        Assert.assertEquals((String)"Bar", (String)compiledCassifier.classify("Madrid is made of water").bestCategory());
    }
}

