/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.classify;

import com.aliasi.classify.ConditionalClassification;
import junit.framework.Assert;
import org.junit.Test;

public class ConditionalClassificationTest {
    @Test
    public void testLinearProbs() {
        String[] cats = new String[]{"foo"};
        double[] probs = new double[]{0.25};
        ConditionalClassification classification = ConditionalClassification.createProbs(cats, probs);
        Assert.assertEquals((int)1, (int)classification.size());
        Assert.assertEquals((String)"foo", (String)classification.category(0));
        Assert.assertEquals((double)1.0, (double)classification.conditionalProbability(0), (double)1.0E-4);
        cats = new String[]{"foo", "bar"};
        probs = new double[]{0.1, 0.3};
        classification = ConditionalClassification.createProbs(cats, probs);
        Assert.assertEquals((int)2, (int)classification.size());
        Assert.assertEquals((String)"bar", (String)classification.category(0));
        Assert.assertEquals((String)"foo", (String)classification.category(1));
        Assert.assertEquals((double)0.75, (double)classification.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)classification.conditionalProbability(1), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExcDiffLengths() {
        ConditionalClassification.createLogProbs(new String[5], new double[6]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExcNaN() {
        ConditionalClassification.createLogProbs(new String[]{"a", "b"}, new double[]{Double.NaN, -5.0});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExcInf() {
        ConditionalClassification.createLogProbs(new String[]{"a", "b"}, new double[]{-5.0, Double.POSITIVE_INFINITY});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExcPos() {
        ConditionalClassification.createLogProbs(new String[]{"a", "b", "c"}, new double[]{-5.0, 1.0, -3.0});
    }

    @Test
    public void testSort() {
        ConditionalClassification classification = ConditionalClassification.createLogProbs(new String[]{"a", "c", "d", "b"}, new double[]{-1.0, -3.0, -3.0, -2.0});
        String[] expectedCats = new String[]{"a", "b", "c", "d"};
        double[] expectedProbs = new double[]{0.5, 0.25, 0.125, 0.125};
        Assert.assertEquals((int)4, (int)classification.size());
        int rank = 0;
        while (rank < 4) {
            Assert.assertEquals((double)expectedProbs[rank], (double)classification.conditionalProbability(rank), (double)1.0E-4);
            Assert.assertEquals((String)expectedCats[rank], (String)classification.category(rank));
            ++rank;
        }
    }

    @Test
    public void testSortScale() {
        ConditionalClassification classification = ConditionalClassification.createLogProbs(new String[]{"a", "c", "d", "b"}, new double[]{-101.0, -103.0, -103.0, -102.0});
        String[] expectedCats = new String[]{"a", "b", "c", "d"};
        double[] expectedProbs = new double[]{0.5, 0.25, 0.125, 0.125};
        Assert.assertEquals((int)4, (int)classification.size());
        int rank = 0;
        while (rank < 4) {
            Assert.assertEquals((double)expectedProbs[rank], (double)classification.conditionalProbability(rank), (double)1.0E-4);
            Assert.assertEquals((String)expectedCats[rank], (String)classification.category(rank));
            ++rank;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSize() {
        new ConditionalClassification(new String[]{"a", "b"}, new double[]{0.5, 0.25, 0.25});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSize2() {
        new ConditionalClassification(new String[]{"a", "b", "c", "d"}, new double[]{0.5, 0.25, 0.25});
    }

    @Test
    public void testSize3() {
        Assert.assertNotNull((Object)new ConditionalClassification(new String[]{"a", "b", "c", "d"}, new double[]{0.5, 0.25, 0.25, 0.0}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTolerance() {
        new ConditionalClassification(new String[]{"a", "b"}, new double[]{0.5, 0.2}, 0.001);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeB() {
        new ConditionalClassification(new String[]{"a", "b"}, new double[]{0.5, 0.25, 0.25}, 0.001);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeB2() {
        new ConditionalClassification(new String[]{"a", "b", "c", "d"}, new double[]{0.5, 0.25, 0.25}, 0.001);
    }

    @Test
    public void testSizeB3() {
        Assert.assertNotNull((Object)new ConditionalClassification(new String[]{"a", "b", "c", "d"}, new double[]{0.5, 0.25, 0.25, 0.0}, 0.001));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToleranceB() {
        new ConditionalClassification(new String[]{"a", "b"}, new double[]{0.5, 0.2}, 0.2);
    }

    @Test
    public void testToleranceB2() {
        Assert.assertNotNull((Object)new ConditionalClassification(new String[]{"a", "b"}, new double[]{0.1, 0.001}, new double[]{0.55, 0.45}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeC() {
        new ConditionalClassification(new String[]{"a", "b"}, new double[]{0.5, 0.2, 0.1}, new double[]{0.5, 0.25, 0.25});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeC2() {
        new ConditionalClassification(new String[]{"a", "b", "c", "d"}, new double[]{15.0, 10.0, 8.0}, new double[]{0.5, 0.25, 0.25});
    }

    @Test
    public void testSizeC3() {
        Assert.assertNotNull((Object)new ConditionalClassification(new String[]{"a", "b", "c", "d"}, new double[]{0.05, 0.025, 0.01, 0.0}, new double[]{0.5, 0.25, 0.25, 0.0}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeC4() {
        new ConditionalClassification(new String[]{"a", "b"}, new double[]{0.5, 0.2, 0.1}, new double[]{0.5, 0.2});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeC5() {
        new ConditionalClassification(new String[]{"a", "b", "c"}, new double[]{0.5, 0.2}, new double[]{0.5, 0.25, 0.25});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeCOrder() {
        new ConditionalClassification(new String[]{"a", "b", "c"}, new double[]{0.5, 0.2, 2.0}, new double[]{0.5, 0.25, 0.25});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeD() {
        new ConditionalClassification(new String[]{"a", "b"}, new double[]{0.5, 0.2, 0.1}, new double[]{0.5, 0.25, 0.25}, 0.1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeD2() {
        new ConditionalClassification(new String[]{"a", "b", "c", "d"}, new double[]{15.0, 10.0, 8.0}, new double[]{0.5, 0.25, 0.25}, 0.1);
    }

    @Test
    public void testSizeD3() {
        Assert.assertNotNull((Object)new ConditionalClassification(new String[]{"a", "b", "c", "d"}, new double[]{0.05, 0.025, 0.01, 0.0}, new double[]{0.5, 0.25, 0.25, 0.0}, 0.001));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeD4() {
        new ConditionalClassification(new String[]{"a", "b"}, new double[]{0.5, 0.2, 0.1}, new double[]{0.5, 0.5}, 0.1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeD5() {
        new ConditionalClassification(new String[]{"a", "b", "c"}, new double[]{0.5, 0.2}, new double[]{0.5, 0.25, 0.25}, 0.1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeDOrder() {
        new ConditionalClassification(new String[]{"a", "b", "c"}, new double[]{0.5, 0.2, 2.0}, new double[]{0.5, 0.25, 0.25}, 0.5);
    }

    @Test
    public void testSizeDTolerance() {
        Assert.assertNotNull((Object)new ConditionalClassification(new String[]{"a", "b", "c"}, new double[]{0.5, 0.2, 0.0}, new double[]{0.5, 0.2, 0.1}, 0.3));
    }

    @Test
    public void testOrdering() {
        ConditionalClassification c = new ConditionalClassification(new String[]{"a", "b", "c"}, new double[]{0.5, 0.25, 0.25});
        Assert.assertEquals((String)"a", (String)c.category(0));
        Assert.assertEquals((String)"b", (String)c.category(1));
        Assert.assertEquals((String)"c", (String)c.category(2));
        Assert.assertEquals((Object)0.5, (Object)c.score(0));
        Assert.assertEquals((Object)0.25, (Object)c.score(1));
        Assert.assertEquals((Object)0.25, (Object)c.score(2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRangeExc() {
        ConditionalClassification c = new ConditionalClassification(new String[]{"a", "b", "c"}, new double[]{0.5, 0.25, 0.25});
        c.conditionalProbability(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRangeExc2() {
        ConditionalClassification c = new ConditionalClassification(new String[]{"a", "b", "c"}, new double[]{0.5, 0.25, 0.25});
        c.conditionalProbability(5);
    }
}

