/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.classify;

import com.aliasi.classify.BigVectorClassifier;
import com.aliasi.classify.ScoredClassification;
import com.aliasi.matrix.SparseFloatVector;
import com.aliasi.matrix.Vector;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class BigVectorClassifierTest {
    @Test
    public void testOne() throws IOException, ClassNotFoundException {
        Vector[] vectorArray = new Vector[3];
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 3;
        vectorArray[0] = new SparseFloatVector(nArray, new float[]{-1.0f, 3.0f, 2.0f}, Integer.MAX_VALUE);
        vectorArray[1] = new SparseFloatVector(new int[]{1, 2, 3}, new float[]{1.0f, -1.0f, 2.0f}, Integer.MAX_VALUE);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        vectorArray[2] = new SparseFloatVector(nArray2, new float[]{-1.0f, 1.0f}, Integer.MAX_VALUE);
        Vector[] termVectors = vectorArray;
        int maxResults = 4;
        BigVectorClassifier classifier = new BigVectorClassifier(termVectors, maxResults);
        Assert.assertNotNull((Object)classifier);
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        SparseFloatVector x1 = new SparseFloatVector(nArray3, new float[]{2.0f, 3.0f}, Integer.MAX_VALUE);
        ScoredClassification c1 = classifier.classify(x1);
        this.assertAsExpected(c1);
        BigVectorClassifier classifier2 = (BigVectorClassifier)AbstractExternalizable.serializeDeserialize(classifier);
        ScoredClassification c2 = classifier2.classify(x1);
        this.assertAsExpected(c2);
    }

    void assertAsExpected(ScoredClassification c) {
        Assert.assertNotNull((Object)c);
        junit.framework.Assert.assertEquals((int)4, (int)c.size());
        junit.framework.Assert.assertEquals((String)"3", (String)c.category(0));
        junit.framework.Assert.assertEquals((double)10.0, (double)c.score(0), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)3.0, (double)c.score(1), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)3.0, (double)c.score(2), (double)1.0E-4);
        HashSet<String> expectedCats = new HashSet<String>();
        expectedCats.add("1");
        expectedCats.add("2");
        HashSet<String> foundCats = new HashSet<String>();
        foundCats.add(c.category(1));
        foundCats.add(c.category(2));
        junit.framework.Assert.assertEquals(expectedCats, foundCats);
        junit.framework.Assert.assertEquals((String)"0", (String)c.category(3));
        junit.framework.Assert.assertEquals((Object)-2.0, (Object)c.score(3));
    }
}

