/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.classify;

import com.aliasi.classify.BernoulliClassifier;
import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.ConditionalClassification;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.TokenFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class BernoulliClassifierTest {
    static final FeatureExtractor FEATURE_EXTRACTOR = new TokenFeatureExtractor(IndoEuropeanTokenizerFactory.INSTANCE);

    static void handle(BernoulliClassifier classifier, String input, Classification c) {
        classifier.handle(new Classified<String>(input, c));
    }

    @Test
    public void testOne() {
        BernoulliClassifier classifier = new BernoulliClassifier(FEATURE_EXTRACTOR);
        BernoulliClassifierTest.handle(classifier, "a b", new Classification("cat1"));
        BernoulliClassifierTest.handle(classifier, "a", new Classification("cat1"));
        BernoulliClassifierTest.handle(classifier, "a b", new Classification("cat2"));
        BernoulliClassifierTest.handle(classifier, "b", new Classification("cat2"));
        Classification c = classifier.classify("a");
        Assert.assertEquals((String)"cat1", (String)c.bestCategory());
        Assert.assertEquals((double)0.75, (double)((ConditionalClassification)c).conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)((ConditionalClassification)c).conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((String)"cat2", (String)classifier.classify("b").bestCategory());
        Assert.assertEquals((double)0.75, (double)((ConditionalClassification)c).conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)((ConditionalClassification)c).conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((String)"cat2", (String)classifier.classify("b b").bestCategory());
        Assert.assertEquals((double)0.75, (double)((ConditionalClassification)c).conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)((ConditionalClassification)c).conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((String)"cat2", (String)classifier.classify("b foo").bestCategory());
        Assert.assertEquals((double)0.75, (double)((ConditionalClassification)c).conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)((ConditionalClassification)c).conditionalProbability(1), (double)1.0E-4);
        BernoulliClassifierTest.handle(classifier, "d", new Classification("cat1"));
        Classification c2 = classifier.classify("d d");
        Assert.assertEquals((String)"cat1", (String)c2.bestCategory());
        Classification c3 = classifier.classify("e");
        Assert.assertEquals((String)"cat1", (String)c3.bestCategory());
    }

    @Test
    public void testSer() throws IOException, ClassNotFoundException {
        BernoulliClassifier classifier = new BernoulliClassifier(FEATURE_EXTRACTOR);
        BernoulliClassifierTest.handle(classifier, "a b", new Classification("cat1"));
        BernoulliClassifierTest.handle(classifier, "a", new Classification("cat1"));
        BernoulliClassifierTest.handle(classifier, "a b", new Classification("cat2"));
        BernoulliClassifierTest.handle(classifier, "b", new Classification("cat2"));
        BernoulliClassifier classifier2 = (BernoulliClassifier)AbstractExternalizable.serializeDeserialize(classifier);
        Classification c = classifier2.classify("a");
        Assert.assertEquals((String)"cat1", (String)c.bestCategory());
        Assert.assertEquals((double)0.75, (double)((ConditionalClassification)c).conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)((ConditionalClassification)c).conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((String)"cat2", (String)classifier.classify("b").bestCategory());
        Assert.assertEquals((double)0.75, (double)((ConditionalClassification)c).conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)((ConditionalClassification)c).conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((String)"cat2", (String)classifier.classify("b b").bestCategory());
        Assert.assertEquals((double)0.75, (double)((ConditionalClassification)c).conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)((ConditionalClassification)c).conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((String)"cat2", (String)classifier.classify("b foo").bestCategory());
        Assert.assertEquals((double)0.75, (double)((ConditionalClassification)c).conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)((ConditionalClassification)c).conditionalProbability(1), (double)1.0E-4);
    }
}

