/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.chunk.TrainTokenShapeChunker;
import com.aliasi.test.unit.chunk.CharLmHmmChunkerTest;
import com.aliasi.tokenizer.IndoEuropeanTokenCategorizer;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import org.junit.Test;

public class TrainTokenShapeChunkerTest {
    @Test
    public void testOne() throws Exception {
        IndoEuropeanTokenizerFactory factory = IndoEuropeanTokenizerFactory.INSTANCE;
        IndoEuropeanTokenCategorizer categorizer = IndoEuropeanTokenCategorizer.CATEGORIZER;
        TrainTokenShapeChunker trainer = new TrainTokenShapeChunker(categorizer, factory);
        String text1 = "John J. Smith lives in Washington.";
        ChunkingImpl chunking1 = new ChunkingImpl(text1);
        Chunk chunk11 = ChunkFactory.createChunk(0, 13, "PER");
        Chunk chunk12 = ChunkFactory.createChunk(23, 33, "LOC");
        chunking1.add(chunk11);
        chunking1.add(chunk12);
        int i = 0;
        while (i < 5) {
            trainer.handle(chunking1);
            ++i;
        }
        Chunker chunker = (Chunker)AbstractExternalizable.compile(trainer);
        CharLmHmmChunkerTest.assertChunking(chunker, chunking1);
        String text2 = "blah blah blah" + text1 + "blah blah.";
        char[] cs = text2.toCharArray();
        int start = "blah blah blah".length();
        Chunking resultChunking2 = chunker.chunk(cs, start, start + text1.length());
        CharLmHmmChunkerTest.assertChunking(chunker, resultChunking2);
    }
}

