/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.test.unit.Asserts;
import com.aliasi.util.Strings;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class ChunkingImplTest {
    @Test(expected=IllegalArgumentException.class)
    public void testMergeClustersExc() {
        ChunkingImpl chunking1 = new ChunkingImpl("abc");
        ChunkingImpl chunking2 = new ChunkingImpl("cde");
        ChunkingImpl.merge(chunking1, chunking2);
    }

    @Test
    public void testMerge() {
        this.assertMerge("abc", Arrays.asList(new Chunk[0]), Arrays.asList(new Chunk[0]), Arrays.asList(new Chunk[0]));
        this.assertMerge("abc", Arrays.asList(ChunkFactory.createChunk(0, 1)), Arrays.asList(new Chunk[0]), Arrays.asList(ChunkFactory.createChunk(0, 1)));
        this.assertMerge("abc", Arrays.asList(new Chunk[0]), Arrays.asList(ChunkFactory.createChunk(0, 1)), Arrays.asList(ChunkFactory.createChunk(0, 1)));
        this.assertMerge("ab de fg", Arrays.asList(ChunkFactory.createChunk(0, 5), ChunkFactory.createChunk(3, 5), ChunkFactory.createChunk(0, 2)), Arrays.asList(new Chunk[0]), Arrays.asList(ChunkFactory.createChunk(0, 2), ChunkFactory.createChunk(3, 5)));
        this.assertMerge("ab de fg", Arrays.asList(new Chunk[0]), Arrays.asList(ChunkFactory.createChunk(0, 5), ChunkFactory.createChunk(3, 5), ChunkFactory.createChunk(0, 2)), Arrays.asList(ChunkFactory.createChunk(0, 2), ChunkFactory.createChunk(3, 5)));
        this.assertMerge("ab cd ef gh", Arrays.asList(ChunkFactory.createChunk(0, 2, "A"), ChunkFactory.createChunk(6, 8, "B")), Arrays.asList(ChunkFactory.createChunk(0, 2, "C"), ChunkFactory.createChunk(3, 5, "D"), ChunkFactory.createChunk(3, 8, "E")), Arrays.asList(ChunkFactory.createChunk(0, 2, "A"), ChunkFactory.createChunk(3, 5, "D"), ChunkFactory.createChunk(6, 8, "B")));
        this.assertMerge("ab cd ef gh", Arrays.asList(ChunkFactory.createChunk(0, 2, "A"), ChunkFactory.createChunk(0, 5, "B")), Arrays.asList(ChunkFactory.createChunk(3, 5, "D")), Arrays.asList(ChunkFactory.createChunk(0, 2, "A"), ChunkFactory.createChunk(3, 5, "D")));
    }

    void assertMerge(CharSequence cs, List<Chunk> chunks1, List<Chunk> chunks2, List<Chunk> chunksExpected) {
        ChunkingImpl chunking1 = new ChunkingImpl(cs);
        chunking1.addAll(chunks1);
        ChunkingImpl chunking2 = new ChunkingImpl(cs);
        chunking2.addAll(chunks2);
        ChunkingImpl chunkingExpected = new ChunkingImpl(cs);
        chunkingExpected.addAll(chunksExpected);
        Assert.assertEquals((Object)chunkingExpected, (Object)ChunkingImpl.merge(chunking1, chunking2));
    }

    @Test
    public void testOverlap() {
        this.assertOverlap(false, 0, 1, 1, 2);
        this.assertOverlap(false, 10, 11, 2, 9);
        this.assertOverlap(true, 0, 1, 0, 2);
        this.assertOverlap(true, 1, 4, 2, 3);
        this.assertOverlap(true, 1, 5, 2, 7);
        this.assertOverlap(true, 1, 5, 2, 5);
    }

    void assertOverlap(boolean overlap, int start1, int end1, int start2, int end2) {
        this.assertOverlapOneWay(overlap, start1, end1, start2, end2);
        this.assertOverlapOneWay(overlap, start2, end2, start1, end1);
    }

    void assertOverlapOneWay(boolean overlap, int start1, int end1, int start2, int end2) {
        Assert.assertEquals((boolean)overlap, (boolean)ChunkingImpl.overlap(ChunkFactory.createChunk(start1, end1), ChunkFactory.createChunk(start2, end2)));
    }

    @Test
    public void testHashCode() {
        ChunkingImpl c1 = new ChunkingImpl("foo bar");
        Assert.assertEquals((int)(Strings.hashCode(c1.charSequence()) + 31 * c1.chunkSet().hashCode()), (int)c1.hashCode());
        c1.add(ChunkFactory.createChunk(0, 3, "FOO"));
        Assert.assertEquals((int)(Strings.hashCode(c1.charSequence()) + 31 * c1.chunkSet().hashCode()), (int)c1.hashCode());
        c1.add(ChunkFactory.createChunk(4, 7, "BAR"));
        Assert.assertEquals((int)(Strings.hashCode(c1.charSequence()) + 31 * c1.chunkSet().hashCode()), (int)c1.hashCode());
    }

    @Test
    public void testEquals() {
        StringBuilder sb = new StringBuilder("foo bar");
        ChunkingImpl c1 = new ChunkingImpl(sb);
        ChunkingImpl c2 = new ChunkingImpl(sb.toString());
        Asserts.assertFullEquals(c1, c2);
        c1.add(ChunkFactory.createChunk(0, 3, "FOO"));
        Assert.assertFalse((boolean)c1.equals(c2));
        c2.add(ChunkFactory.createChunk(0, 3, "FOO"));
        Asserts.assertFullEquals(c1, c2);
        c1.add(ChunkFactory.createChunk(0, 3, "FOO"));
        Asserts.assertFullEquals(c1, c2);
        c2.add(ChunkFactory.createChunk(4, 7, "BAR"));
        Assert.assertFalse((boolean)c1.equals(c2));
        c1.add(ChunkFactory.createChunk(4, 7, "BAR"));
        Asserts.assertFullEquals(c1, c2);
    }

    @Test
    public void testSeq() {
        String seq = "span of text";
        ChunkingImpl c1 = new ChunkingImpl(seq);
        ChunkingImpl c2 = new ChunkingImpl(seq.toCharArray(), 0, seq.length());
        Assert.assertEquals((Object)seq, (Object)c1.charSequence());
        Assert.assertEquals((Object)seq, (Object)c2.charSequence());
        Assert.assertEquals((Object)c1.charSequence(), (Object)c2.charSequence());
    }

    @Test
    public void testSet() {
        String seq = "012345";
        ChunkingImpl chunking = new ChunkingImpl(seq);
        LinkedHashSet set1 = new LinkedHashSet();
        Assert.assertEquals(set1, chunking.chunkSet());
    }

    @Test
    public void testAdd() {
        String seq = "012345";
        ChunkingImpl chunking = new ChunkingImpl(seq);
        Chunk c1 = ChunkFactory.createChunk(0, 1, "foo");
        chunking.add(c1);
        LinkedHashSet<Chunk> set1 = new LinkedHashSet<Chunk>();
        set1.add(c1);
        LinkedHashSet<Chunk> set2 = new LinkedHashSet<Chunk>(chunking.chunkSet());
        Assert.assertEquals(set1, set2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThrow() {
        String seq = "012345";
        ChunkingImpl chunking = new ChunkingImpl(seq);
        Chunk c1 = ChunkFactory.createChunk(0, 101, "foo");
        chunking.add(c1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThrow2() {
        String seq = "012345";
        ChunkingImpl chunking = new ChunkingImpl(seq);
        Chunk c1 = ChunkFactory.createChunk(100, 101, "foo");
        chunking.add(c1);
    }
}

