/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.test.unit.Asserts;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import junit.framework.Assert;
import org.junit.Test;

public class ChunkFactoryTest {
    @Test
    public void testTypeScore() {
        Chunk c1 = ChunkFactory.createChunk(4, 7, "word", 1.0);
        Assert.assertEquals((int)4, (int)c1.start());
        Assert.assertEquals((int)7, (int)c1.end());
        Assert.assertEquals((double)1.0, (double)c1.score(), (double)1.0E-4);
        Assert.assertEquals((String)"word", (String)c1.type());
    }

    @Test
    public void testType() {
        Chunk c1 = ChunkFactory.createChunk(4, 7, "word");
        Assert.assertEquals((int)4, (int)c1.start());
        Assert.assertEquals((int)7, (int)c1.end());
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)c1.score(), (double)1.0E-4);
        Assert.assertEquals((String)"word", (String)c1.type());
    }

    @Test
    public void testScore() {
        Chunk c1 = ChunkFactory.createChunk(4, 7, 1.0);
        Assert.assertEquals((int)4, (int)c1.start());
        Assert.assertEquals((int)7, (int)c1.end());
        Assert.assertEquals((double)1.0, (double)c1.score(), (double)1.0E-4);
        Assert.assertEquals((String)"CHUNK", (String)c1.type());
    }

    @Test
    public void testNone() {
        Chunk c1 = ChunkFactory.createChunk(4, 7);
        Assert.assertEquals((int)4, (int)c1.start());
        Assert.assertEquals((int)7, (int)c1.end());
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)c1.score(), (double)1.0E-4);
        Assert.assertEquals((String)"CHUNK", (String)c1.type());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThrow1() {
        ChunkFactory.createChunk(4, 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThrow2() {
        ChunkFactory.createChunk(-1, 3);
    }

    @Test
    public void testOrder() {
        Chunk c1 = ChunkFactory.createChunk(0, 1, "foo");
        Chunk c2 = ChunkFactory.createChunk(1, 2, "bar");
        Chunk c3 = ChunkFactory.createChunk(2, 3, "foo");
        Chunk[] chunks = new Chunk[]{c1, c2, c3};
        TreeSet<Chunk> set = new TreeSet<Chunk>(Chunk.TEXT_ORDER_COMPARATOR);
        set.addAll(Arrays.asList(chunks));
        Iterator<Chunk> it = set.iterator();
        int i = 0;
        while (i < chunks.length) {
            Assert.assertEquals((Object)chunks[i], (Object)it.next());
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testOverlapOrder() {
        Chunk c1 = ChunkFactory.createChunk(0, 1, "foo");
        Chunk c2 = ChunkFactory.createChunk(0, 3, "foo");
        Chunk c3 = ChunkFactory.createChunk(2, 4, "bar");
        Chunk[] chunks = new Chunk[]{c1, c2, c3};
        TreeSet<Chunk> set = new TreeSet<Chunk>(Chunk.TEXT_ORDER_COMPARATOR);
        set.addAll(Arrays.asList(chunks));
        Iterator<Chunk> it = set.iterator();
        int i = 0;
        while (i < chunks.length) {
            Assert.assertEquals((Object)chunks[i], (Object)it.next());
            ++i;
        }
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testEquality() {
        Chunk c1 = ChunkFactory.createChunk(0, 2, "foo");
        Chunk c2 = ChunkFactory.createChunk(0, 2, "foo");
        Chunk c3 = ChunkFactory.createChunk(0, 2, "bar");
        Chunk c4 = ChunkFactory.createChunk(0, 1, "foo");
        Chunk c5 = ChunkFactory.createChunk(1, 2, "foo");
        Asserts.assertFullEquals(c1, c1);
        Asserts.assertFullEquals(c1, c2);
        Asserts.assertNotEquals(c1, c3);
        Asserts.assertNotEquals(c1, c4);
        Asserts.assertNotEquals(c1, c5);
    }
}

