/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkAndCharSeq;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.test.unit.Asserts;
import junit.framework.Assert;
import org.junit.Test;

public class ChunkAndCharSeqTest {
    @Test
    public void testEquals() {
        String seq = "span of text";
        Chunk c1 = ChunkFactory.createChunk(0, 1, "foo");
        ChunkAndCharSeq cacs1 = new ChunkAndCharSeq(c1, seq);
        Assert.assertEquals((String)seq, (String)cacs1.charSequence());
        Assert.assertEquals((Object)c1, (Object)cacs1.chunk());
        Assert.assertEquals((Object)seq.subSequence(0, 1), (Object)cacs1.span());
        ChunkAndCharSeq cacs2 = new ChunkAndCharSeq(c1, seq);
        Assert.assertEquals((Object)cacs1, (Object)cacs2);
        Asserts.assertFullEquals(cacs1, cacs1);
    }

    @Test
    public void testContext() {
        String seq = "0123456789";
        Chunk c1 = ChunkFactory.createChunk(3, 6, "foo");
        ChunkAndCharSeq cacs1 = new ChunkAndCharSeq(c1, seq);
        Assert.assertEquals((String)cacs1.span().toString(), (String)"345");
        Assert.assertEquals((String)cacs1.spanStartContext(1).toString(), (String)"23");
        Assert.assertEquals((String)cacs1.spanEndContext(1).toString(), (String)"56");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThrowConstructor() {
        String seq = "012345";
        Chunk c1 = ChunkFactory.createChunk(0, 101, "foo");
        new ChunkAndCharSeq(c1, seq);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThrowContext() {
        String seq = "012345";
        Chunk c1 = ChunkFactory.createChunk(0, 1, "foo");
        ChunkAndCharSeq cacs1 = new ChunkAndCharSeq(c1, seq);
        cacs1.spanStartContext(-9);
    }
}

