/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.symbol;

import com.aliasi.symbol.SymbolTable;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapSymbolTable
implements Serializable,
SymbolTable {
    static final long serialVersionUID = 3515814090489781415L;
    final HashMap<String, Integer> mSymbolToId = new HashMap();
    final HashMap<Integer, String> mIdToSymbol = new HashMap();
    private int mNextSymbol;

    public MapSymbolTable() {
        this(0);
    }

    public MapSymbolTable(int firstId) {
        this.mNextSymbol = firstId;
    }

    public MapSymbolTable(Map<String, Integer> symbolToIdMap) {
        int maxSymbol = -1;
        for (Map.Entry<String, Integer> entry : symbolToIdMap.entrySet()) {
            String symbol = entry.getKey();
            Integer id = entry.getValue();
            if (id == -1) {
                String msg = "Symbols cannot be equal to the unknown symbol ID. MapSymbolTable.UNKNOWN_SYMBOL_ID=-1 found id=" + id;
                throw new IllegalArgumentException(msg);
            }
            if (this.mIdToSymbol.put(id, symbol) != null) {
                String msg = "Identifiers must be unique. Found duplicate identifiers. Identifier=" + id;
                throw new IllegalArgumentException(msg);
            }
            maxSymbol = Math.max(maxSymbol, entry.getValue());
        }
        this.mNextSymbol = maxSymbol + 1;
        this.mSymbolToId.putAll(symbolToIdMap);
    }

    public Set<Integer> idSet() {
        return Collections.unmodifiableSet(this.mIdToSymbol.keySet());
    }

    public Set<String> symbolSet() {
        return Collections.unmodifiableSet(this.mSymbolToId.keySet());
    }

    private MapSymbolTable(ObjectInput objIn) throws IOException {
        int numEntries = objIn.readInt();
        int max = 0;
        int i = 0;
        while (i < numEntries) {
            String symbol = objIn.readUTF();
            Integer id = objIn.readInt();
            max = Math.max(max, id);
            this.mSymbolToId.put(symbol, id);
            this.mIdToSymbol.put(id, symbol);
            ++i;
        }
        this.mNextSymbol = max + 1;
    }

    Object writeReplace() {
        return new Externalizer(this);
    }

    @Override
    public int numSymbols() {
        return this.mSymbolToId.size();
    }

    @Override
    public int symbolToID(String symbol) {
        Integer result = this.symbolToIDInteger(symbol);
        return result == null ? -1 : result;
    }

    public Integer symbolToIDInteger(String symbol) {
        return this.mSymbolToId.get(symbol);
    }

    public String idToSymbol(Integer id) {
        String symbol = this.mIdToSymbol.get(id);
        if (symbol == null) {
            String msg = "Could not find id=" + id;
            throw new IndexOutOfBoundsException(msg);
        }
        return symbol;
    }

    @Override
    public String idToSymbol(int id) {
        return this.idToSymbol((Integer)id);
    }

    @Override
    public int removeSymbol(String symbol) {
        int id = this.symbolToID(symbol);
        if (id >= 0) {
            this.mSymbolToId.remove(symbol);
            this.mIdToSymbol.remove(id);
        }
        return id;
    }

    @Override
    public void clear() {
        this.mSymbolToId.clear();
        this.mIdToSymbol.clear();
    }

    @Override
    public int getOrAddSymbol(String symbol) {
        return this.getOrAddSymbolInteger(symbol);
    }

    public Integer getOrAddSymbolInteger(String symbol) {
        Integer id = this.mSymbolToId.get(symbol);
        if (id != null) {
            return id;
        }
        Integer freshId = this.mNextSymbol++;
        this.mSymbolToId.put(symbol, freshId);
        this.mIdToSymbol.put(freshId, symbol);
        return freshId;
    }

    public String toString() {
        return this.mIdToSymbol.toString();
    }

    public static SymbolTable unmodifiableView(SymbolTable table) {
        return new UnmodifiableViewTable(table);
    }

    /* synthetic */ MapSymbolTable(ObjectInput objectInput, MapSymbolTable mapSymbolTable) throws IOException {
        this(objectInput);
    }

    private static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = -6040616216389802649L;
        final MapSymbolTable mSymbolTable;

        public Externalizer() {
            this.mSymbolTable = null;
        }

        public Externalizer(MapSymbolTable symbolTable) {
            this.mSymbolTable = symbolTable;
        }

        @Override
        public Object read(ObjectInput in) throws IOException {
            return new MapSymbolTable(in, null);
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeInt(this.mSymbolTable.mSymbolToId.size());
            for (Map.Entry<String, Integer> entry : this.mSymbolTable.mSymbolToId.entrySet()) {
                objOut.writeUTF(entry.getKey());
                objOut.writeInt(entry.getValue());
            }
        }
    }

    private static class UnmodifiableViewTable
    implements SymbolTable,
    Serializable {
        static final long serialVersionUID = 3326236896411055713L;
        private final SymbolTable mSymbolTable;
        static final String UNSUPPORTED_MSG = "Cannot modify the underlying symbol table from this view.";

        UnmodifiableViewTable(SymbolTable symbolTable) {
            this.mSymbolTable = symbolTable;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public int getOrAddSymbol(String symbol) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public int removeSymbol(String symbol) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public String idToSymbol(int id) {
            return this.mSymbolTable.idToSymbol(id);
        }

        @Override
        public int numSymbols() {
            return this.mSymbolTable.numSymbols();
        }

        @Override
        public int symbolToID(String symbol) {
            return this.mSymbolTable.symbolToID(symbol);
        }

        public String toString() {
            return this.mSymbolTable.toString();
        }

        Object writeReplace() {
            return new Serializer(this);
        }

        static class Serializer
        extends AbstractExternalizable {
            static final long serialVersionUID = -5293452773208612837L;
            final UnmodifiableViewTable mSymbolTable;

            public Serializer() {
                this(null);
            }

            public Serializer(UnmodifiableViewTable symbolTable) {
                this.mSymbolTable = symbolTable;
            }

            @Override
            public void writeExternal(ObjectOutput objOut) throws IOException {
                objOut.writeObject(this.mSymbolTable.mSymbolTable);
            }

            @Override
            public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
                SymbolTable symbolTable = (SymbolTable)in.readObject();
                return new UnmodifiableViewTable(symbolTable);
            }
        }
    }
}

