/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.symbol;

import com.aliasi.symbol.SymbolTable;
import com.aliasi.util.AbstractExternalizable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;

class CompiledSymbolTable
implements SymbolTable,
Serializable {
    static final long serialVersionUID = -8025428413920807070L;
    private final String[] mSymbols;

    public CompiledSymbolTable(String[] symbols) {
        this.mSymbols = new String[symbols.length];
        System.arraycopy(symbols, 0, this.mSymbols, 0, symbols.length);
        Arrays.sort(this.mSymbols);
    }

    private CompiledSymbolTable(String[] symbols, boolean ignore) {
        this.mSymbols = symbols;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    public String toString() {
        return Arrays.asList(this.mSymbols).toString();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.numSymbols());
        int i = 0;
        while (i < this.numSymbols()) {
            String symbol = this.idToSymbol(i);
            out.writeShort(symbol.length());
            out.writeChars(symbol);
            ++i;
        }
    }

    void writeObj(ObjectOutput out) throws IOException {
        out.writeInt(this.numSymbols());
        int i = 0;
        while (i < this.numSymbols()) {
            String symbol = this.idToSymbol(i);
            out.writeShort(symbol.length());
            out.writeChars(symbol);
            ++i;
        }
    }

    @Override
    public int symbolToID(String symbol) {
        int result = Arrays.binarySearch(this.mSymbols, symbol);
        return result < 0 ? -1 : result;
    }

    @Override
    public String idToSymbol(int id) {
        return this.mSymbols[id];
    }

    @Override
    public int numSymbols() {
        return this.mSymbols.length;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getOrAddSymbol(String symbol) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int removeSymbol(String symbol) {
        throw new UnsupportedOperationException();
    }

    /* synthetic */ CompiledSymbolTable(String[] stringArray, boolean bl, CompiledSymbolTable compiledSymbolTable) {
        this(stringArray, bl);
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 2115083345444042460L;
        private final CompiledSymbolTable mSymbolTable;
        static final boolean IGNORE = true;

        public Serializer(CompiledSymbolTable symbolTable) {
            this.mSymbolTable = symbolTable;
        }

        public Serializer() {
            this(null);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.mSymbolTable.mSymbols.length);
            String[] stringArray = this.mSymbolTable.mSymbols;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String symbol = stringArray[n2];
                out.writeUTF(symbol);
                ++n2;
            }
        }

        @Override
        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            int numSymbols = in.readInt();
            String[] symbols = new String[numSymbols];
            int i = 0;
            while (i < numSymbols) {
                symbols[i] = in.readUTF();
                ++i;
            }
            return new CompiledSymbolTable(symbols, true, null);
        }
    }
}

