/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

import com.aliasi.stats.PoissonConstant;
import com.aliasi.stats.PoissonDistribution;
import java.io.IOException;
import java.io.ObjectOutput;

public class PoissonEstimator
extends PoissonDistribution {
    private double mSum = 0.0;
    private double mNumSamples = 0.0;

    public PoissonEstimator() {
    }

    public PoissonEstimator(double priorNumSamples, double priorMean) {
        if (priorMean <= 0.0 || Double.isNaN(priorMean) || Double.isInfinite(priorMean)) {
            String msg = "Prior mean must be finite and positive. Found priorMean=" + priorMean;
            throw new IllegalArgumentException(msg);
        }
        if (priorNumSamples <= 0.0 || Double.isNaN(priorNumSamples) || Double.isInfinite(priorNumSamples)) {
            String msg = "Prior number of samples must be finite and positive. Found priorNumSamples=" + priorNumSamples;
            throw new IllegalArgumentException(msg);
        }
        this.mSum = priorMean * priorNumSamples;
        this.mNumSamples = priorNumSamples;
    }

    public void train(long sample) {
        this.train(sample, 1.0);
    }

    public void train(long sample, double weight) {
        if (sample < 0L) {
            String msg = "Poisson distributions only have positive outcomes. Found training sample=" + sample;
            throw new IllegalArgumentException(msg);
        }
        if (weight < 0.0 || Double.isNaN(weight) || Double.isInfinite(weight)) {
            String msg = "Training weights must be finite and positive. Found weight=" + weight;
            throw new IllegalArgumentException(msg);
        }
        if (9.223372036854776E18 - this.mSum < (double)sample) {
            String msg = "Adding last sample overflows the event sum. Sum so far=" + this.mSum + " Number of training samples=" + this.mNumSamples;
            throw new IllegalStateException(msg);
        }
        this.mSum += (double)sample * weight;
        this.mNumSamples += weight;
    }

    @Override
    public double mean() {
        if (this.mSum <= 0.0) {
            String msg = this.mNumSamples == 0.0 ? "No samples provided." : "Only zero samples provided.";
            throw new IllegalStateException(msg);
        }
        return this.mSum / this.mNumSamples;
    }

    public void compileTo(ObjectOutput objOut) throws IOException {
        PoissonConstant dist = new PoissonConstant(this.mean());
        dist.compileTo(objOut);
    }
}

