/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

import com.aliasi.stats.PoissonDistribution;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PoissonConstant
extends PoissonDistribution {
    private final double mMean;

    public PoissonConstant(double mean) {
        if (mean <= 0.0) {
            String msg = "Mean must be finite and strictly > 0. Found mean=" + mean;
            throw new IllegalArgumentException(msg);
        }
        this.mMean = mean;
    }

    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    @Override
    public double mean() {
        return this.mMean;
    }

    private static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = -2824074866517957016L;
        final PoissonConstant mDistro;

        public Externalizer() {
            this.mDistro = null;
        }

        Externalizer(PoissonConstant distro) {
            this.mDistro = distro;
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeDouble(this.mDistro.mean());
        }

        @Override
        protected Object read(ObjectInput objIn) throws IOException {
            return new PoissonConstant(objIn.readDouble());
        }
    }
}

