/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

import com.aliasi.stats.MultivariateDistribution;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class MultivariateConstant
extends MultivariateDistribution {
    final String[] mLabels;
    final double[] mEstimates;
    final Map<String, Long> mLabelToIndex;

    public MultivariateConstant(int numOutcomes) {
        this(MultivariateConstant.allOnes(numOutcomes));
    }

    public MultivariateConstant(long[] counts) {
        this(MultivariateConstant.toDouble(counts));
    }

    public MultivariateConstant(double[] probabilityRatios) {
        this(probabilityRatios, null, null);
    }

    public MultivariateConstant(String[] labels) {
        this(MultivariateConstant.allOnes(labels.length), labels);
    }

    public MultivariateConstant(long[] counts, String[] labels) {
        this(MultivariateConstant.toDouble(counts), labels);
    }

    public MultivariateConstant(double[] probabilityRatios, String[] labels) {
        this(probabilityRatios, (String[])labels.clone(), new HashMap<String, Long>());
        this.validateEqualLengths(probabilityRatios, labels);
        int i = 0;
        while (i < labels.length) {
            if (this.mLabelToIndex.put(labels[i], Long.valueOf(i)) != null) {
                String msg = "Duplicate labels=" + labels[i];
                throw new IllegalArgumentException(msg);
            }
            ++i;
        }
    }

    private MultivariateConstant(double[] probabilityRatios, String[] labels, Map<String, Long> labelToIndex) {
        if (probabilityRatios.length < 1) {
            String msg = "Require at least one count or probability ratio.";
            throw new IllegalArgumentException(msg);
        }
        this.mLabels = labels;
        this.mLabelToIndex = labelToIndex;
        this.validateRatios(probabilityRatios);
        double z = 0.0;
        int i = 0;
        while (i < probabilityRatios.length) {
            z += probabilityRatios[i];
            ++i;
        }
        this.mEstimates = new double[probabilityRatios.length];
        i = 0;
        while (i < probabilityRatios.length) {
            this.mEstimates[i] = probabilityRatios[i] / z;
            ++i;
        }
    }

    @Override
    public int numDimensions() {
        return this.mEstimates.length;
    }

    @Override
    public long outcome(String outcomeLabel) {
        if (this.mLabels == null) {
            return super.outcome(outcomeLabel);
        }
        Long result = this.mLabelToIndex.get(outcomeLabel);
        if (result == null) {
            String msg = "Unknown outcome label=" + outcomeLabel;
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    @Override
    public String label(long outcome) {
        if (this.mLabels == null) {
            return super.label(outcome);
        }
        this.checkOutcome(outcome);
        return this.mLabels[(int)outcome];
    }

    @Override
    public double probability(long outcome) {
        return this.outcomeOutOfRange(outcome) ? 0.0 : this.mEstimates[(int)outcome];
    }

    private void validateEqualLengths(double[] probabilityRatios, String[] labels) {
        if (probabilityRatios.length != labels.length) {
            String msg = "Require same number of ratios and labels. Found #ratios=" + probabilityRatios.length + " # labels=" + labels.length;
            throw new IllegalArgumentException(msg);
        }
    }

    private void validateRatios(double[] probabilityRatios) {
        int i = 0;
        while (i < probabilityRatios.length) {
            if (probabilityRatios[i] < 0.0) {
                String msg = "All probability ratios must be >= 0. Found probabilityRatios[" + i + "]=" + probabilityRatios[i];
                throw new IllegalArgumentException(msg);
            }
            ++i;
        }
    }

    static double[] toDouble(long[] counts) {
        double[] result = new double[counts.length];
        int i = 0;
        while (i < counts.length) {
            if (counts[i] < 0L) {
                String msg = "All counts must be positive. Found counts[" + i + "]=" + counts[i];
                throw new IllegalArgumentException(msg);
            }
            result[i] = counts[i];
            ++i;
        }
        return result;
    }

    static double[] allOnes(int length) {
        if (length < 0) {
            String msg = "Number of outcomes must be positive.Found number of outcomes=" + length;
            throw new IllegalArgumentException(msg);
        }
        double[] result = new double[length];
        Arrays.fill(result, 1.0);
        return result;
    }

    static String[] numberedLabels(int length) {
        String[] labels = new String[length];
        int i = 0;
        while (i < length) {
            labels[i] = Integer.toString(i);
            ++i;
        }
        return labels;
    }
}

