/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.spell.WeightedEditDistance;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class FixedWeightEditDistance
extends WeightedEditDistance
implements Compilable,
Serializable {
    static final long serialVersionUID = 6520949001598595981L;
    private final double mMatchWeight;
    private final double mDeleteWeight;
    private final double mInsertWeight;
    private final double mSubstituteWeight;
    private final double mTransposeWeight;

    public FixedWeightEditDistance(double matchWeight, double deleteWeight, double insertWeight, double substituteWeight, double transposeWeight) {
        this.mMatchWeight = matchWeight;
        this.mDeleteWeight = deleteWeight;
        this.mInsertWeight = insertWeight;
        this.mSubstituteWeight = substituteWeight;
        this.mTransposeWeight = transposeWeight;
    }

    public FixedWeightEditDistance() {
        this(0.0, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Edit Distance Class=" + this.getClass());
        sb.append("FixedWeightEditDistance costs:");
        sb.append("  match weight=" + this.mMatchWeight);
        sb.append("  insert weight=" + this.mInsertWeight);
        sb.append("  delete weight=" + this.mDeleteWeight);
        sb.append("  substitute weight=" + this.mSubstituteWeight);
        sb.append("  transpose weight=" + this.mTransposeWeight);
        return sb.toString();
    }

    private Object writeReplace() {
        return new Externalizer(this);
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    @Override
    public double matchWeight(char cMatched) {
        return this.mMatchWeight;
    }

    @Override
    public double deleteWeight(char cDeleted) {
        return this.mDeleteWeight;
    }

    @Override
    public double insertWeight(char cInserted) {
        return this.mInsertWeight;
    }

    @Override
    public double substituteWeight(char cDeleted, char cInserted) {
        return this.mSubstituteWeight;
    }

    @Override
    public double transposeWeight(char cFirst, char cSecond) {
        return this.mTransposeWeight;
    }

    private static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = 636473803792927790L;
        private final FixedWeightEditDistance mFWED;

        public Externalizer() {
            this.mFWED = null;
        }

        public Externalizer(FixedWeightEditDistance fwed) {
            this.mFWED = fwed;
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeDouble(this.mFWED.mMatchWeight);
            objOut.writeDouble(this.mFWED.mDeleteWeight);
            objOut.writeDouble(this.mFWED.mInsertWeight);
            objOut.writeDouble(this.mFWED.mSubstituteWeight);
            objOut.writeDouble(this.mFWED.mTransposeWeight);
        }

        @Override
        public Object read(ObjectInput objIn) throws IOException {
            return new FixedWeightEditDistance(objIn.readDouble(), objIn.readDouble(), objIn.readDouble(), objIn.readDouble(), objIn.readDouble());
        }
    }
}

