/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.DenseVector;
import com.aliasi.matrix.Matrix;
import com.aliasi.matrix.Vector;

public class Matrices {
    private Matrices() {
    }

    public static Vector unmodifiableVector(Vector v) {
        return new UnmodifiableVector(v);
    }

    public static boolean hasZeroDiagonal(Matrix m) {
        int n = m.numRows();
        if (n != m.numColumns()) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (m.value(i, i) != 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSymmetric(Matrix m) {
        int n = m.numRows();
        if (n != m.numColumns()) {
            return false;
        }
        int i = 0;
        while (i < n) {
            int j = i + 1;
            while (j < n) {
                if (m.value(i, j) != m.value(j, i)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNonNegative(Matrix m) {
        int i = 0;
        while (i < m.numRows()) {
            int j = 0;
            while (j < m.numColumns()) {
                if (m.value(i, j) < 0.0 || Double.isNaN(m.value(i, j))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static double[] toArray(Vector v) {
        double[] xs = new double[v.numDimensions()];
        int i = 0;
        while (i < xs.length) {
            xs[i] = v.value(i);
            ++i;
        }
        return xs;
    }

    static Vector add(Vector v1, Vector v2) {
        int numDimensions = v1.numDimensions();
        if (numDimensions != v2.numDimensions()) {
            String msg = "Can only add vectors of the same dimensionality. Found v1.numDimensions()=" + v1.numDimensions() + " v2.numDimensions()=" + v2.numDimensions();
            throw new IllegalArgumentException(msg);
        }
        double[] vals = new double[numDimensions];
        int i = 0;
        while (i < numDimensions) {
            vals[i] = v1.value(i) + v2.value(i);
            ++i;
        }
        return new DenseVector(vals);
    }

    static class UnmodifiableVector
    extends VectorFilter {
        UnmodifiableVector(Vector v) {
            super(v);
        }

        @Override
        public void setValue(int dimension, double value) {
            String msg = "Cannot modify an unmodifiable vector.";
            throw new UnsupportedOperationException(msg);
        }

        public String toString() {
            return this.mV.toString();
        }
    }

    static class VectorFilter
    implements Vector {
        protected final Vector mV;

        VectorFilter(Vector v) {
            this.mV = v;
        }

        @Override
        public int[] nonZeroDimensions() {
            return this.mV.nonZeroDimensions();
        }

        @Override
        public void increment(double scale, Vector v) {
            this.mV.increment(scale, v);
        }

        @Override
        public Vector add(Vector v) {
            return this.mV.add(v);
        }

        @Override
        public double cosine(Vector v) {
            return this.mV.cosine(v);
        }

        @Override
        public double dotProduct(Vector v) {
            return this.mV.dotProduct(v);
        }

        @Override
        public boolean equals(Object that) {
            return this.mV.equals(that);
        }

        @Override
        public int hashCode() {
            return this.mV.hashCode();
        }

        @Override
        public double length() {
            return this.mV.length();
        }

        @Override
        public int numDimensions() {
            return this.mV.numDimensions();
        }

        @Override
        public void setValue(int dimension, double value) {
            this.mV.setValue(dimension, value);
        }

        @Override
        public double value(int dimension) {
            return this.mV.value(dimension);
        }
    }
}

