/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.LanguageModel;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Exceptions;
import com.aliasi.util.Math;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class UniformProcessLM
implements LanguageModel.Dynamic,
LanguageModel.Process {
    private final int mNumOutcomes;
    private final double mLog2EstimatePerChar;

    public UniformProcessLM() {
        this(65535);
    }

    public UniformProcessLM(int numOutcomes) {
        UniformProcessLM.validateNumOutcomes(numOutcomes);
        this.mNumOutcomes = numOutcomes;
        this.mLog2EstimatePerChar = -Math.log2(numOutcomes);
    }

    public UniformProcessLM(double crossEntropyRate) {
        Exceptions.finiteNonNegative("Cross-entropy rate", crossEntropyRate);
        this.mLog2EstimatePerChar = -crossEntropyRate;
        this.mNumOutcomes = (int)java.lang.Math.pow(2.0, crossEntropyRate);
    }

    private UniformProcessLM(int numOutcomes, double log2EstimatePerChar) {
        this.mNumOutcomes = numOutcomes;
        this.mLog2EstimatePerChar = log2EstimatePerChar;
    }

    public int numOutcomes() {
        return this.mNumOutcomes;
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    @Override
    public void handle(CharSequence cs) {
    }

    @Override
    public void train(char[] cs, int start, int end) {
    }

    @Override
    public void train(char[] cs, int start, int end, int count) {
    }

    @Override
    public void train(CharSequence cSeq) {
    }

    @Override
    public void train(CharSequence cSeq, int count) {
    }

    @Override
    public double log2Estimate(char[] cs, int start, int end) {
        Strings.checkArgsStartEnd(cs, start, end);
        return this.log2Estimate(end - start);
    }

    @Override
    public double log2Estimate(CharSequence cSeq) {
        return this.log2Estimate(cSeq.length());
    }

    private double log2Estimate(int length) {
        return this.mLog2EstimatePerChar * (double)length;
    }

    static void validateNumOutcomes(int numOutcomes) {
        if (numOutcomes <= 0) {
            String msg = "Number of outcomes must be > 0. Found=" + numOutcomes;
            throw new IllegalArgumentException(msg);
        }
        if (numOutcomes > 65535) {
            String msg = "Num outcomes must be <=65535 Found value=" + numOutcomes;
            throw new IllegalArgumentException(msg);
        }
    }

    private static UniformProcessLM createUniformProcessLM(int numOutcomes, double log2EstimatePerChar) {
        return new UniformProcessLM(numOutcomes, log2EstimatePerChar);
    }

    private static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = 8496069837136242338L;
        private final UniformProcessLM mLM;

        public Externalizer() {
            this.mLM = null;
        }

        public Externalizer(UniformProcessLM lm) {
            this.mLM = lm;
        }

        @Override
        public Object read(ObjectInput objIn) throws IOException {
            int numOutcomes = objIn.readInt();
            double log2EstimatePerChar = objIn.readDouble();
            return UniformProcessLM.createUniformProcessLM(numOutcomes, log2EstimatePerChar);
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            objOut.writeInt(this.mLM.numOutcomes());
            objOut.writeDouble(this.mLM.mLog2EstimatePerChar);
        }
    }
}

