/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.TrieReader;
import java.io.IOException;
import java.util.Stack;

public class MultiTrieReader
implements TrieReader {
    private final Stack<Long> mStack1 = new Stack();
    private final Stack<Long> mStack2 = new Stack();
    private final TrieReader mReader1;
    private final TrieReader mReader2;
    private boolean mNotInitialized = true;

    public MultiTrieReader(TrieReader reader1, TrieReader reader2) {
        this.mReader1 = reader1;
        this.mReader2 = reader2;
    }

    @Override
    public long readSymbol() throws IOException {
        if (this.mStack1.size() > this.mStack2.size()) {
            long symbol = this.mStack1.peek();
            if (symbol == -1L) {
                this.mStack1.pop();
                MultiTrieReader.replace(this.mStack1, this.mReader1);
            } else {
                MultiTrieReader.replace(this.mStack1, -2L);
            }
            return symbol;
        }
        if (this.mStack1.size() < this.mStack2.size()) {
            long symbol = this.mStack2.peek();
            if (symbol == -1L) {
                this.mStack2.pop();
                MultiTrieReader.replace(this.mStack2, this.mReader2);
            } else {
                MultiTrieReader.replace(this.mStack2, -2L);
            }
            return symbol;
        }
        long top1 = this.mStack1.peek();
        long top2 = this.mStack2.peek();
        if (top1 == -1L && top2 == -1L) {
            this.mStack1.pop();
            MultiTrieReader.replace(this.mStack1, this.mReader1);
            this.mStack2.pop();
            MultiTrieReader.replace(this.mStack2, this.mReader2);
            return -1L;
        }
        if (top2 == -1L || top1 != -1L && top1 < top2) {
            MultiTrieReader.replace(this.mStack1, -2L);
            return top1;
        }
        if (top1 == -1L || top2 != -1L && top2 < top1) {
            MultiTrieReader.replace(this.mStack2, -2L);
            return top2;
        }
        MultiTrieReader.replace(this.mStack1, -2L);
        MultiTrieReader.replace(this.mStack2, -2L);
        return top1;
    }

    @Override
    public long readCount() throws IOException {
        if (this.mNotInitialized) {
            this.mNotInitialized = false;
            long count = this.mReader1.readCount() + this.mReader2.readCount();
            this.mStack1.push(this.mReader1.readSymbol());
            this.mStack2.push(this.mReader2.readSymbol());
            return count;
        }
        if (this.mStack1.size() > this.mStack2.size()) {
            long count = this.mReader1.readCount();
            this.mStack1.push(this.mReader1.readSymbol());
            return count;
        }
        if (this.mStack1.size() < this.mStack2.size()) {
            long count = this.mReader2.readCount();
            this.mStack2.push(this.mReader2.readSymbol());
            return count;
        }
        if (this.mStack1.peek() == -2L && this.mStack2.peek() == -2L) {
            long count = this.mReader1.readCount() + this.mReader2.readCount();
            this.mStack1.push(this.mReader1.readSymbol());
            this.mStack2.push(this.mReader2.readSymbol());
            return count;
        }
        if (this.mStack1.peek() == -2L) {
            long count = this.mReader1.readCount();
            this.mStack1.push(this.mReader1.readSymbol());
            return count;
        }
        if (this.mStack2.peek() == -2L) {
            long count = this.mReader2.readCount();
            this.mStack2.push(this.mReader2.readSymbol());
            return count;
        }
        throw new IllegalStateException("readCount(): Stack1=" + this.mStack1 + " Stack2=" + this.mStack2);
    }

    static void replace(Stack<Long> stack, TrieReader reader) throws IOException {
        if (stack.size() > 0) {
            MultiTrieReader.replace(stack, reader.readSymbol());
        }
    }

    static void replace(Stack<Long> stack, long x) {
        if (stack.size() == 0) {
            return;
        }
        stack.pop();
        stack.push(x);
    }
}

