/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.hmm;

import com.aliasi.hmm.HiddenMarkovModel;
import com.aliasi.symbol.SymbolTable;
import com.aliasi.util.Math;

public abstract class AbstractHmm
implements HiddenMarkovModel {
    private final SymbolTable mStateSymbolTable;

    public AbstractHmm(SymbolTable stateSymbolTable) {
        this.mStateSymbolTable = stateSymbolTable;
    }

    public boolean addState(String state) {
        if (this.mStateSymbolTable.symbolToID(state) >= 0) {
            return false;
        }
        this.mStateSymbolTable.getOrAddSymbol(state);
        return true;
    }

    @Override
    public SymbolTable stateSymbolTable() {
        return this.mStateSymbolTable;
    }

    @Override
    public abstract double startProb(String var1);

    @Override
    public double startProb(int stateId) {
        String state = this.stateSymbolTable().idToSymbol(stateId);
        return this.startProb(state);
    }

    @Override
    public double startLog2Prob(String state) {
        return Math.log2(this.startProb(state));
    }

    @Override
    public double startLog2Prob(int stateId) {
        return Math.log2(this.startProb(stateId));
    }

    @Override
    public abstract double endProb(String var1);

    @Override
    public double endProb(int stateId) {
        String state = this.stateSymbolTable().idToSymbol(stateId);
        if (stateId < 0) {
            return 0.0;
        }
        return this.endProb(state);
    }

    @Override
    public double endLog2Prob(String state) {
        return Math.log2(this.endProb(state));
    }

    @Override
    public double endLog2Prob(int stateId) {
        return Math.log2(this.endProb(stateId));
    }

    @Override
    public abstract double transitProb(String var1, String var2);

    @Override
    public double transitProb(int sourceId, int targetId) {
        return this.transitProb(this.mStateSymbolTable.idToSymbol(sourceId), this.mStateSymbolTable.idToSymbol(targetId));
    }

    @Override
    public double transitLog2Prob(String source, String target) {
        return Math.log2(this.transitProb(source, target));
    }

    @Override
    public double transitLog2Prob(int sourceId, int targetId) {
        return Math.log2(this.transitProb(sourceId, targetId));
    }

    @Override
    public abstract double emitProb(String var1, CharSequence var2);

    @Override
    public double emitProb(int stateId, CharSequence emission) {
        return this.emitProb(this.mStateSymbolTable.idToSymbol(stateId), emission);
    }

    @Override
    public double emitLog2Prob(int stateId, CharSequence emission) {
        return Math.log2(this.emitProb(stateId, emission));
    }

    @Override
    public double emitLog2Prob(String state, CharSequence emission) {
        return Math.log2(this.emitProb(state, emission));
    }
}

