/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.features;

import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.BinaryMap;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;

public class StringLengthFeatureExtractor
implements FeatureExtractor<CharSequence>,
Serializable {
    static final long serialVersionUID = 4390057742097519384L;
    private final int[] mLengths;
    private final String[] mFeatureNames;

    public StringLengthFeatureExtractor(int ... lengths) {
        if (lengths.length < 1) {
            String msg = "Require non-empty array of lengths.";
            throw new IllegalArgumentException(msg);
        }
        int i = 0;
        while (i < lengths.length) {
            if (lengths[i] < 0) {
                String msg = "Lengths must be non-negative. Found lengths[" + i + "]=" + lengths[i];
                throw new IllegalArgumentException(msg);
            }
            ++i;
        }
        TreeSet<Integer> lengthSet = new TreeSet<Integer>();
        int[] nArray = lengths;
        int n = lengths.length;
        int n2 = 0;
        while (n2 < n) {
            int length = nArray[n2];
            lengthSet.add(length);
            ++n2;
        }
        this.mLengths = new int[lengthSet.size()];
        int pos = 0;
        for (Integer length : lengthSet) {
            this.mLengths[pos] = length;
            ++pos;
        }
        this.mFeatureNames = new String[this.mLengths.length];
        int i2 = 0;
        while (i2 < this.mLengths.length) {
            this.mFeatureNames[i2] = "LEN>=" + this.mLengths[i2];
            ++i2;
        }
    }

    @Override
    public Map<String, ? extends Number> features(CharSequence in) {
        int len = in.length();
        int end = 0;
        while (end < this.mLengths.length && len >= this.mLengths[end]) {
            ++end;
        }
        if (end == 0) {
            return Collections.emptyMap();
        }
        BinaryMap<String> features = new BinaryMap<String>();
        int i = 0;
        while (i < end) {
            features.add(this.mFeatureNames[i]);
            ++i;
        }
        return features;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 5726292832004631457L;
        StringLengthFeatureExtractor mExtractor;

        public Serializer() {
            this(null);
        }

        public Serializer(StringLengthFeatureExtractor extractor) {
            this.mExtractor = extractor;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            Serializer.writeInts(this.mExtractor.mLengths, out);
        }

        @Override
        public Object read(ObjectInput in) throws IOException {
            int[] lengths = Serializer.readInts(in);
            return new StringLengthFeatureExtractor(lengths);
        }
    }
}

