/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dict;

import com.aliasi.dict.DictionaryEntry;
import java.util.Arrays;

class Node<C> {
    static final DictionaryEntry[] EMPTY_ENTRIES = new DictionaryEntry[0];
    static final char[] EMPTY_CHARS = new char[0];
    static final Node[] EMPTY_NODES = new Node[0];
    DictionaryEntry<C>[] mEntries = Node.emptyEntries();
    char[] mDtrChars = EMPTY_CHARS;
    Node<C>[] mDtrNodes = Node.emptyNodes();

    Node() {
    }

    static <D> DictionaryEntry<D>[] emptyEntries() {
        DictionaryEntry[] entries = EMPTY_ENTRIES;
        return entries;
    }

    static <D> Node<D>[] emptyNodes() {
        Node[] nodes = EMPTY_NODES;
        return nodes;
    }

    Node<C> getDtr(char c) {
        int i = Arrays.binarySearch(this.mDtrChars, c);
        return i < 0 ? null : this.mDtrNodes[i];
    }

    Node<C> getOrAddDtr(char c) {
        Node<C> dtr = this.getDtr(c);
        if (dtr != null) {
            return dtr;
        }
        Node<C> result = new Node<C>();
        char[] oldDtrChars = this.mDtrChars;
        Node<C>[] oldDtrNodes = this.mDtrNodes;
        this.mDtrChars = new char[this.mDtrChars.length + 1];
        Node[] dtrNodes = new Node[this.mDtrNodes.length + 1];
        this.mDtrNodes = dtrNodes;
        int i = 0;
        while (i < oldDtrChars.length) {
            if (oldDtrChars[i] > c) break;
            this.mDtrChars[i] = oldDtrChars[i];
            this.mDtrNodes[i] = oldDtrNodes[i];
            ++i;
        }
        this.mDtrChars[i] = c;
        this.mDtrNodes[i] = result;
        while (i < oldDtrChars.length) {
            this.mDtrChars[i + 1] = oldDtrChars[i];
            this.mDtrNodes[i + 1] = oldDtrNodes[i];
            ++i;
        }
        return result;
    }

    void addEntry(DictionaryEntry<C> entry) {
        DictionaryEntry<C>[] oldEntries = this.mEntries;
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].equals(entry)) {
                return;
            }
            ++i;
        }
        DictionaryEntry[] entries = new DictionaryEntry[oldEntries.length + 1];
        this.mEntries = entries;
        this.mEntries[0] = entry;
        System.arraycopy(oldEntries, 0, this.mEntries, 1, oldEntries.length);
    }
}

